/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.Node;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.JunctionNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.model.rete.builder.BuildContext;
import com.bstek.urule.model.rete.builder.BuildContextImpl;
import com.bstek.urule.model.rete.builder.CriterionBuilder;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.lhs.BaseCriterion;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.loop.LoopRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReteBuilder
implements ApplicationContextAware {
    public static final String BEAN_ID = "urule.reteBuilder";
    private static Collection<CriterionBuilder> criterionBuilders;

    public Rete buildRete(List<Rule> rules, ResourceLibrary resourceLibrary) {
        ArrayList<ObjectTypeNode> objectTypeNodes = new ArrayList<ObjectTypeNode>();
        Rete rete = new Rete(objectTypeNodes, resourceLibrary);
        BuildContextImpl context = new BuildContextImpl(resourceLibrary, objectTypeNodes);
        for (Rule rule : rules) {
            if (rule instanceof LoopRule || rule.getLhs() == null || rule.getLhs().getCriterion() == null) continue;
            this.buildBranch(rule, context);
        }
        return rete;
    }

    private void buildBranch(Rule rule, BuildContext context) {
        Line conn;
        Node fromNode;
        JunctionNode junctionNode;
        List<Line> toConnections;
        context.setCurrentRule(rule);
        Criterion criterion = rule.getLhs().getCriterion();
        BaseReteNode prevNode = ReteBuilder.buildCriterion(context, criterion);
        if (prevNode instanceof JunctionNode && (toConnections = (junctionNode = (JunctionNode)prevNode).getToConnections()).size() == 1 && (fromNode = (conn = toConnections.get(0)).getFrom()) instanceof CriteriaNode) {
            CriteriaNode cnode = (CriteriaNode)fromNode;
            cnode.getLines().remove(conn);
            prevNode = cnode;
        }
        TerminalNode terminalNode = new TerminalNode(rule, context.nextId());
        prevNode.addLine(terminalNode);
    }

    public static BaseReteNode buildCriterion(BuildContext context, Criterion criterion) {
        BaseReteNode prevNode = null;
        for (CriterionBuilder criterionBuilder : criterionBuilders) {
            if (!criterionBuilder.support(criterion)) continue;
            prevNode = criterionBuilder.buildCriterion((BaseCriterion)criterion, context);
            break;
        }
        if (prevNode == null) {
            throw new RuleException("Unknow criterion : " + criterion);
        }
        return prevNode;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        criterionBuilders = applicationContext.getBeansOfType(CriterionBuilder.class).values();
    }
}

