/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.OrNode;
import com.bstek.urule.model.rete.builder.BuildContext;
import com.bstek.urule.model.rete.builder.JunctionBuilder;
import com.bstek.urule.model.rule.lhs.BaseCriterion;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Or;
import java.util.ArrayList;
import java.util.List;

public class OrBuilder
extends JunctionBuilder {
    @Override
    public BaseReteNode buildCriterion(BaseCriterion c, BuildContext context) {
        Or or = (Or)c;
        List<Criterion> criterions = or.getCriterions();
        if (criterions == null || criterions.size() == 0) {
            throw new RuleException("Condition join node[or] need one child at least.");
        }
        ArrayList<BaseReteNode> childNodes = new ArrayList<BaseReteNode>();
        for (Criterion criterion : criterions) {
            BaseReteNode node = this.buildCriterion(criterion, context, null);
            if (node == null) continue;
            childNodes.add(node);
        }
        if (childNodes.size() == 0) {
            return null;
        }
        if (childNodes.size() == 1) {
            return (BaseReteNode)childNodes.get(0);
        }
        OrNode orNode = new OrNode(context.nextId());
        for (BaseReteNode node : childNodes) {
            node.addLine(orNode);
        }
        return orNode;
    }

    @Override
    public boolean support(Criterion criterion) {
        return criterion instanceof Or;
    }
}

