/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete.builder;

import com.bstek.urule.model.Node;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.ConditionNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.NamedCriteriaNode;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.builder.BuildContext;
import com.bstek.urule.model.rule.lhs.BaseCriteria;
import com.bstek.urule.model.rule.lhs.BaseCriterion;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.NamedCriteria;
import java.util.HashMap;
import java.util.List;

public abstract class CriterionBuilder {
    public abstract BaseReteNode buildCriterion(BaseCriterion var1, BuildContext var2);

    public abstract boolean support(Criterion var1);

    protected BaseReteNode buildCriteria(Criteria criteria, ConditionNode prevNode, BuildContext context) {
        String objectType = context.getObjectType(criteria);
        if (prevNode != null && !(prevNode instanceof NamedCriteriaNode)) {
            CriteriaNode targetNode = null;
            boolean match = false;
            if (objectType.equals("*")) {
                match = true;
            } else {
                String prevObjectType = context.getObjectType(prevNode.getCriteria());
                if (objectType.equals(prevObjectType)) {
                    match = true;
                }
            }
            if (match) {
                List<ReteNode> prevChildrenNodes = prevNode.getChildrenNodes();
                targetNode = this.fetchSameCriteriaNode(criteria, prevChildrenNodes);
                if (targetNode == null) {
                    targetNode = new CriteriaNode(criteria, context.nextId(), context.currentRuleIsDebug());
                    prevNode.addLine(targetNode);
                }
            } else {
                targetNode = this.buildCriteriaNode(criteria, context, objectType);
            }
            return targetNode;
        }
        if (objectType.equals("*")) {
            objectType = HashMap.class.getName();
        }
        CriteriaNode criteriaNode = this.buildCriteriaNode(criteria, context, objectType);
        return criteriaNode;
    }

    protected NamedCriteriaNode buildNamedCriteria(NamedCriteria criteria, ConditionNode prevNode, BuildContext context) {
        NamedCriteriaNode node = this.buildNewTypeNamedCriteria(criteria, context);
        return node;
    }

    private CriteriaNode buildCriteriaNode(BaseCriteria criteria, BuildContext context, String objectType) {
        ObjectTypeNode targetObjectTypeNode = context.buildObjectTypeNode(objectType);
        List<ReteNode> childrenNodes = targetObjectTypeNode.getChildrenNodes();
        CriteriaNode targetNode = this.fetchSameCriteriaNode(criteria, childrenNodes);
        if (targetNode == null) {
            targetNode = new CriteriaNode((Criteria)criteria, context.nextId(), context.currentRuleIsDebug());
            targetObjectTypeNode.addLine(targetNode);
        }
        return targetNode;
    }

    private NamedCriteriaNode buildNewTypeNamedCriteria(NamedCriteria criteria, BuildContext context) {
        VariableCategory category = context.getResourceLibrary().getVariableCategory(criteria.getVariableCategory());
        String objectType = category.getClazz();
        ObjectTypeNode targetObjectTypeNode = context.buildObjectTypeNode(objectType);
        List<ReteNode> childrenNodes = targetObjectTypeNode.getChildrenNodes();
        NamedCriteriaNode targetNode = this.fetchExistNamedCriteriaNode(criteria, childrenNodes);
        if (targetNode == null) {
            targetNode = new NamedCriteriaNode(criteria, context.nextId(), context.currentRuleIsDebug());
            targetObjectTypeNode.addLine(targetNode);
        }
        return targetNode;
    }

    private CriteriaNode fetchSameCriteriaNode(BaseCriteria criteria, List<ReteNode> childrenNodes) {
        String conditionId = criteria.getId();
        CriteriaNode targetNode = null;
        for (Node node : childrenNodes) {
            ConditionNode baseNode;
            String nodeId;
            if (!(node instanceof ConditionNode) || criteria instanceof Criteria && !(node instanceof CriteriaNode) || criteria instanceof NamedCriteria && !(node instanceof NamedCriteriaNode) || !(nodeId = (baseNode = (ConditionNode)((Object)node)).getCriteriaInfo()).equals(conditionId)) continue;
            targetNode = (CriteriaNode)baseNode;
            break;
        }
        return targetNode;
    }

    private NamedCriteriaNode fetchExistNamedCriteriaNode(NamedCriteria criteria, List<ReteNode> childrenNodes) {
        String conditionId = criteria.getId();
        NamedCriteriaNode targetNode = null;
        for (Node node : childrenNodes) {
            NamedCriteriaNode baseNode;
            String nodeId;
            if (!(node instanceof NamedCriteriaNode) || !(nodeId = (baseNode = (NamedCriteriaNode)node).getCriteriaInfo()).equals(conditionId)) continue;
            targetNode = baseNode;
            break;
        }
        return targetNode;
    }
}

