/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.builder.BuildContext;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.ParameterValue;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.AbstractLeftPart;
import com.bstek.urule.model.rule.lhs.BaseCriteria;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.NamedCriteria;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import java.util.List;

public class BuildContextImpl
implements BuildContext {
    private ResourceLibrary resourceLibrary;
    private List<ObjectTypeNode> objectTypeNodes;
    private int id = 0;
    private Rule currentRule;

    public BuildContextImpl(ResourceLibrary resourceLibrary, List<ObjectTypeNode> objectTypeNodes) {
        this.resourceLibrary = resourceLibrary;
        this.objectTypeNodes = objectTypeNodes;
    }

    @Override
    public boolean assertSameType(BaseCriteria left, BaseCriteria right) {
        VariableCategory leftCategory = this.fetchVariableCategory(left);
        VariableCategory rightCategory = this.fetchVariableCategory(right);
        if (leftCategory == null || rightCategory == null) {
            return false;
        }
        return leftCategory.getClazz().equals(rightCategory.getClazz());
    }

    private VariableCategory fetchVariableCategory(BaseCriteria criteria) {
        VariableCategory vc = null;
        if (criteria instanceof Criteria) {
            Criteria c = (Criteria)criteria;
            LeftPart leftLeftPart = c.getLeft().getLeftPart();
            if (leftLeftPart instanceof VariableLeftPart) {
                VariableLeftPart part = (VariableLeftPart)leftLeftPart;
                vc = this.resourceLibrary.getVariableCategory(part.getVariableCategory());
            }
        } else if (criteria instanceof NamedCriteria) {
            NamedCriteria c = (NamedCriteria)criteria;
            vc = this.resourceLibrary.getVariableCategory(c.getVariableCategory());
        } else {
            throw new RuleException("Unknow Criteria : " + criteria);
        }
        return vc;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode(BaseCriteria criteria) {
        String objectType = this.getObjectType(criteria);
        return this.buildObjectTypeNode(objectType);
    }

    @Override
    public String getObjectType(BaseCriteria criteria) {
        String className = null;
        if (criteria instanceof Criteria) {
            Criteria c = (Criteria)criteria;
            LeftPart leftPart = c.getLeft().getLeftPart();
            if (leftPart instanceof VariableLeftPart) {
                VariableLeftPart varPart = (VariableLeftPart)leftPart;
                String variableCategory = varPart.getVariableCategory();
                VariableCategory category = this.resourceLibrary.getVariableCategory(variableCategory);
                className = category.getClazz();
            } else if (leftPart instanceof AbstractLeftPart) {
                AbstractLeftPart lp = (AbstractLeftPart)leftPart;
                VariableCategory category = this.resourceLibrary.getVariableCategory(lp.getVariableCategory());
                className = category.getClazz();
            } else if (leftPart instanceof CommonFunctionLeftPart) {
                CommonFunctionLeftPart funPart = (CommonFunctionLeftPart)leftPart;
                CommonFunctionParameter parameter = funPart.getParameter();
                Value value = parameter.getObjectParameter();
                className = this.buildValueClass(value);
            } else if (leftPart instanceof MethodLeftPart) {
                MethodLeftPart methodLeftPart = (MethodLeftPart)leftPart;
                List<Parameter> params = methodLeftPart.getParameters();
                if (params != null && params.size() > 0) {
                    Parameter param = params.get(0);
                    Value value = param.getValue();
                    className = this.buildValueClass(value);
                } else {
                    className = "*";
                }
            } else if (leftPart instanceof FunctionLeftPart) {
                FunctionLeftPart funLeftPart = (FunctionLeftPart)leftPart;
                List<Parameter> params = funLeftPart.getParameters();
                if (params != null && params.size() > 0) {
                    Parameter param = params.get(0);
                    Value value = param.getValue();
                    className = this.buildValueClass(value);
                } else {
                    className = "*";
                }
            } else {
                className = "*";
            }
        } else if (criteria instanceof NamedCriteria) {
            NamedCriteria c = (NamedCriteria)criteria;
            VariableCategory category = this.resourceLibrary.getVariableCategory(c.getVariableCategory());
            className = category.getClazz();
        } else {
            throw new RuleException("Unknow Criteria : " + criteria);
        }
        return className;
    }

    private String buildValueClass(Value value) {
        String className;
        if (value instanceof VariableValue) {
            VariableValue varValue = (VariableValue)value;
            String variableCategory = varValue.getVariableCategory();
            VariableCategory category = this.resourceLibrary.getVariableCategory(variableCategory);
            className = category.getClazz();
        } else if (value instanceof ParameterValue) {
            VariableCategory category = this.resourceLibrary.getVariableCategory("\u53c2\u6570");
            className = category.getClazz();
        } else if (value instanceof VariableCategoryValue) {
            VariableCategoryValue categoryValue = (VariableCategoryValue)value;
            VariableCategory category = this.resourceLibrary.getVariableCategory(categoryValue.getVariableCategory());
            className = category.getClazz();
        } else {
            className = "*";
        }
        return className;
    }

    @Override
    public ObjectTypeNode buildObjectTypeNode(String className) {
        ObjectTypeNode targetObjectTypeNode = null;
        for (ObjectTypeNode typeNode : this.objectTypeNodes) {
            if (!typeNode.support(className)) continue;
            targetObjectTypeNode = typeNode;
            break;
        }
        if (targetObjectTypeNode == null) {
            targetObjectTypeNode = new ObjectTypeNode(className, this.nextId());
            this.objectTypeNodes.add(targetObjectTypeNode);
        }
        return targetObjectTypeNode;
    }

    @Override
    public ResourceLibrary getResourceLibrary() {
        return this.resourceLibrary;
    }

    @Override
    public int nextId() {
        return this.id++;
    }

    @Override
    public void setCurrentRule(Rule rule) {
        this.currentRule = rule;
    }

    @Override
    public boolean currentRuleIsDebug() {
        if (this.currentRule == null) {
            return false;
        }
        return this.currentRule.getDebug() != null && this.currentRule.getDebug() != false;
    }
}

