/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.rete.AndNode;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.ConditionNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.JunctionNode;
import com.bstek.urule.model.rete.NamedCriteriaNode;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.builder.BuildContext;
import com.bstek.urule.model.rete.builder.JunctionBuilder;
import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.BaseCriterion;
import com.bstek.urule.model.rule.lhs.Criterion;
import java.util.List;

public class AndBuilder
extends JunctionBuilder {
    @Override
    public BaseReteNode buildCriterion(BaseCriterion c, BuildContext context) {
        And and = (And)c;
        AndNode andNode = null;
        ConditionNode currentCriteriaNode = null;
        List<Criterion> criterions = and.getCriterions();
        if (criterions == null || criterions.size() == 0) {
            throw new RuleException("Condition join node[and] need one child at least.");
        }
        for (Criterion criterion : criterions) {
            List<ReteNode> childrenNodes;
            BaseReteNode node = this.buildCriterion(criterion, context, currentCriteriaNode);
            if (node == null) continue;
            if (node instanceof CriteriaNode) {
                if (currentCriteriaNode != null && !(childrenNodes = currentCriteriaNode.getChildrenNodes()).contains(node)) {
                    if (andNode == null) {
                        andNode = new AndNode(context.nextId());
                    }
                    currentCriteriaNode.addLine(andNode);
                }
                currentCriteriaNode = (ConditionNode)((Object)node);
                continue;
            }
            if (node instanceof JunctionNode) {
                if (andNode == null) {
                    andNode = new AndNode(context.nextId());
                }
                ((JunctionNode)node).addLine(andNode);
                continue;
            }
            if (!(node instanceof NamedCriteriaNode)) continue;
            if (currentCriteriaNode != null && !(childrenNodes = currentCriteriaNode.getChildrenNodes()).contains(node)) {
                if (andNode == null) {
                    andNode = new AndNode(context.nextId());
                }
                currentCriteriaNode.addLine(andNode);
            }
            currentCriteriaNode = (ConditionNode)((Object)node);
        }
        if (criterions.size() == 1 && currentCriteriaNode != null) {
            return (BaseReteNode)((Object)currentCriteriaNode);
        }
        if (andNode == null) {
            return (BaseReteNode)((Object)currentCriteriaNode);
        }
        if (andNode != null && currentCriteriaNode != null) {
            currentCriteriaNode.addLine(andNode);
        }
        return andNode;
    }

    @Override
    public boolean support(Criterion criterion) {
        return criterion instanceof And;
    }
}

