/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.model.AbstractJsonDeserializer;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rete.AndNode;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.JsonUtils;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.NamedCriteriaNode;
import com.bstek.urule.model.rete.NodeType;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.OrNode;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.model.rule.ArithmeticType;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.SimpleArithmetic;
import com.bstek.urule.model.rule.SimpleArithmeticValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.AllLeftPart;
import com.bstek.urule.model.rule.lhs.CollectLeftPart;
import com.bstek.urule.model.rule.lhs.CollectPurpose;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.CriteriaUnit;
import com.bstek.urule.model.rule.lhs.EvalLeftPart;
import com.bstek.urule.model.rule.lhs.ExistLeftPart;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.JunctionType;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.MultiCondition;
import com.bstek.urule.model.rule.lhs.NamedCriteria;
import com.bstek.urule.model.rule.lhs.PropertyCriteria;
import com.bstek.urule.model.rule.lhs.StatisticType;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;

public class ReteNodeJsonDeserializer
extends AbstractJsonDeserializer<List<ReteNode>> {
    public List<ReteNode> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode jsonNode = oc.readTree(jsonParser);
        ArrayList<ReteNode> reteNodes = new ArrayList<ReteNode>();
        Iterator childrenNodesIter = jsonNode.getElements();
        while (childrenNodesIter.hasNext()) {
            JsonNode criteriaNode;
            ReteNode node;
            JsonNode childNode = (JsonNode)childrenNodesIter.next();
            int id = childNode.get("id").getIntValue();
            JsonNode nodeTypeNode = childNode.get("nodeType");
            if (nodeTypeNode == null) continue;
            String nodeTypeText = nodeTypeNode.getTextValue();
            NodeType nodeType = NodeType.valueOf(nodeTypeText);
            ReteNode reteNode = NodeType.newReteNodeInstance(nodeType);
            if (reteNode instanceof ObjectTypeNode) {
                node = (ObjectTypeNode)reteNode;
                ((ObjectTypeNode)node).setObjectTypeClass(childNode.get("objectTypeClass").getTextValue());
                node.setId(id);
            } else if (reteNode instanceof AndNode) {
                node = (AndNode)reteNode;
                node.setId(id);
                ((AndNode)node).setToLineCount(childNode.get("toLineCount").getIntValue());
                ((BaseReteNode)node).setLines(this.parseLines(childNode));
            } else if (reteNode instanceof OrNode) {
                node = (OrNode)reteNode;
                node.setId(id);
                ((BaseReteNode)node).setLines(this.parseLines(childNode));
            } else if (reteNode instanceof CriteriaNode) {
                node = (CriteriaNode)reteNode;
                node.setId(id);
                criteriaNode = childNode.get("criteria");
                ((CriteriaNode)node).setCriteria(this.parseCriteria(criteriaNode));
                ((BaseReteNode)node).setLines(this.parseLines(childNode));
            } else if (reteNode instanceof NamedCriteriaNode) {
                node = (NamedCriteriaNode)reteNode;
                criteriaNode = childNode.get("criteria");
                ((NamedCriteriaNode)node).setCriteria(this.parseNamedCriteria(criteriaNode));
                ((BaseReteNode)node).setLines(this.parseLines(childNode));
                node.setId(id);
            } else if (reteNode instanceof TerminalNode) {
                node = (TerminalNode)reteNode;
                node.setId(id);
                ((TerminalNode)node).setRule(this.parseRule(jsonParser, childNode));
            }
            reteNodes.add(reteNode);
        }
        return reteNodes;
    }

    private List<Line> parseLines(JsonNode node) {
        JsonNode lineNodes = node.get("lines");
        if (lineNodes == null) {
            return null;
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        for (JsonNode jsonNode : lineNodes) {
            Line line = new Line();
            line.setFromNodeId(jsonNode.get("fromNodeId").getIntValue());
            line.setToNodeId(jsonNode.get("toNodeId").getIntValue());
            lines.add(line);
        }
        return lines;
    }

    private NamedCriteria parseNamedCriteria(JsonNode jsonNode) {
        NamedCriteria criteria = new NamedCriteria();
        criteria.setReferenceName(jsonNode.get("referenceName").getTextValue());
        criteria.setVariableCategory(jsonNode.get("variableCategory").getTextValue());
        JsonNode unitNode = jsonNode.get("unit");
        if (unitNode != null) {
            CriteriaUnit unit = this.parseCriteriaUnit(unitNode);
            criteria.setUnit(unit);
        }
        return criteria;
    }

    private CriteriaUnit parseCriteriaUnit(JsonNode unitNode) {
        JsonNode nextUnitNodes;
        JsonNode junctionTypeNode;
        CriteriaUnit unit = new CriteriaUnit();
        JsonNode criteriaNode = unitNode.get("criteria");
        if (criteriaNode != null) {
            unit.setCriteria(this.parseCriteria(criteriaNode));
        }
        if ((junctionTypeNode = unitNode.get("junctionType")) != null) {
            unit.setJunctionType(JunctionType.valueOf(junctionTypeNode.getTextValue()));
        }
        if ((nextUnitNodes = unitNode.get("nextUnits")) != null) {
            ArrayList<CriteriaUnit> nextUnits = new ArrayList<CriteriaUnit>();
            for (JsonNode nextNode : nextUnitNodes) {
                nextUnits.add(this.parseCriteriaUnit(nextNode));
            }
            unit.setNextUnits(nextUnits);
        }
        return unit;
    }

    private Criteria parseCriteria(JsonNode jsonNode) {
        Criteria criteria = new Criteria();
        String opText = jsonNode.get("op").getTextValue();
        Op op = Op.valueOf(opText);
        criteria.setOp(op);
        JsonNode leftJsonNode = jsonNode.get("left");
        Left left = new Left();
        criteria.setLeft(left);
        String type = JsonUtils.getJsonValue(leftJsonNode, "type");
        JsonNode leftPartJsonNode = leftJsonNode.get("leftPart");
        left.setType(LeftType.valueOf(type));
        switch (left.getType()) {
            case function: {
                FunctionLeftPart funPart = new FunctionLeftPart();
                funPart.setName(JsonUtils.getJsonValue(leftPartJsonNode, "name"));
                funPart.setParameters(JsonUtils.parseParameters(leftPartJsonNode));
                left.setLeftPart(funPart);
                break;
            }
            case method: {
                MethodLeftPart methodPart = new MethodLeftPart();
                methodPart.setBeanId(JsonUtils.getJsonValue(leftPartJsonNode, "beanId"));
                methodPart.setBeanLabel(JsonUtils.getJsonValue(leftPartJsonNode, "beanLabel"));
                methodPart.setMethodLabel(JsonUtils.getJsonValue(leftPartJsonNode, "methodLabel"));
                methodPart.setMethodName(JsonUtils.getJsonValue(leftPartJsonNode, "methodName"));
                methodPart.setParameters(JsonUtils.parseParameters(leftPartJsonNode));
                left.setLeftPart(methodPart);
                break;
            }
            case eval: {
                EvalLeftPart evalPart = new EvalLeftPart();
                evalPart.setExpression(JsonUtils.getJsonValue(leftPartJsonNode, "expression"));
                left.setLeftPart(evalPart);
                break;
            }
            case all: {
                AllLeftPart allLeftPart = new AllLeftPart();
                String statisticTypeStr = JsonUtils.getJsonValue(leftPartJsonNode, "statisticType");
                StatisticType statisticType = StatisticType.valueOf(statisticTypeStr);
                allLeftPart.setStatisticType(statisticType);
                if (statisticType.equals((Object)StatisticType.percent)) {
                    allLeftPart.setPercent(Integer.valueOf(JsonUtils.getJsonValue(leftPartJsonNode, "percent")));
                } else if (statisticType.equals((Object)StatisticType.amount)) {
                    allLeftPart.setAmount(Integer.valueOf(JsonUtils.getJsonValue(leftPartJsonNode, "amount")));
                }
                allLeftPart.setVariableCategory(JsonUtils.getJsonValue(leftPartJsonNode, "variableCategory"));
                allLeftPart.setVariableLabel(JsonUtils.getJsonValue(leftPartJsonNode, "variableLabel"));
                allLeftPart.setVariableName(JsonUtils.getJsonValue(leftPartJsonNode, "variableName"));
                JsonNode multiConditionNode = leftPartJsonNode.get("multiCondition");
                allLeftPart.setMultiCondition(this.parseMultiCondition(multiConditionNode));
                left.setLeftPart(allLeftPart);
                break;
            }
            case exist: {
                ExistLeftPart existLeftPart = new ExistLeftPart();
                String existStatisticTypeStr = JsonUtils.getJsonValue(leftPartJsonNode, "statisticType");
                StatisticType existStatisticType = StatisticType.valueOf(existStatisticTypeStr);
                existLeftPart.setStatisticType(existStatisticType);
                if (existStatisticType.equals((Object)StatisticType.percent)) {
                    existLeftPart.setPercent(Integer.valueOf(JsonUtils.getJsonValue(leftPartJsonNode, "percent")));
                } else if (existStatisticType.equals((Object)StatisticType.amount)) {
                    existLeftPart.setAmount(Integer.valueOf(JsonUtils.getJsonValue(leftPartJsonNode, "amount")));
                }
                existLeftPart.setVariableCategory(JsonUtils.getJsonValue(leftPartJsonNode, "variableCategory"));
                existLeftPart.setVariableLabel(JsonUtils.getJsonValue(leftPartJsonNode, "variableLabel"));
                existLeftPart.setVariableName(JsonUtils.getJsonValue(leftPartJsonNode, "variableName"));
                JsonNode existMultiConditionNode = leftPartJsonNode.get("multiCondition");
                existLeftPart.setMultiCondition(this.parseMultiCondition(existMultiConditionNode));
                left.setLeftPart(existLeftPart);
                break;
            }
            case collect: {
                CollectLeftPart collectLeftPart = new CollectLeftPart();
                collectLeftPart.setVariableCategory(JsonUtils.getJsonValue(leftPartJsonNode, "variableCategory"));
                collectLeftPart.setVariableLabel(JsonUtils.getJsonValue(leftPartJsonNode, "variableLabel"));
                collectLeftPart.setVariableName(JsonUtils.getJsonValue(leftPartJsonNode, "variableName"));
                collectLeftPart.setProperty(JsonUtils.getJsonValue(leftPartJsonNode, "property"));
                collectLeftPart.setPurpose(CollectPurpose.valueOf(JsonUtils.getJsonValue(leftPartJsonNode, "purpose")));
                JsonNode collectMultiConditionNode = leftPartJsonNode.get("multiCondition");
                collectLeftPart.setMultiCondition(this.parseMultiCondition(collectMultiConditionNode));
                left.setLeftPart(collectLeftPart);
                break;
            }
            case commonfunction: {
                CommonFunctionLeftPart functionPart = new CommonFunctionLeftPart();
                functionPart.setLabel(JsonUtils.getJsonValue(leftPartJsonNode, "label"));
                functionPart.setName(JsonUtils.getJsonValue(leftPartJsonNode, "name"));
                functionPart.setParameter(JsonUtils.parseCommonFunctionParameter(leftPartJsonNode));
                left.setLeftPart(functionPart);
                break;
            }
            default: {
                VariableLeftPart varPart = new VariableLeftPart();
                varPart.setVariableCategory(JsonUtils.getJsonValue(leftPartJsonNode, "variableCategory"));
                varPart.setVariableLabel(JsonUtils.getJsonValue(leftPartJsonNode, "variableLabel"));
                varPart.setVariableName(JsonUtils.getJsonValue(leftPartJsonNode, "variableName"));
                varPart.setDatatype(Datatype.valueOf(JsonUtils.getJsonValue(leftPartJsonNode, "datatype")));
                left.setLeftPart(varPart);
            }
        }
        left.setArithmetic(this.parseSimpleArithmetic(leftJsonNode));
        Value value = JsonUtils.parseValue(jsonNode);
        if (value != null) {
            criteria.setValue(value);
        }
        return criteria;
    }

    private MultiCondition parseMultiCondition(JsonNode multiConditionNode) {
        MultiCondition condition = new MultiCondition();
        condition.setType(JunctionType.valueOf(JsonUtils.getJsonValue(multiConditionNode, "type")));
        Iterator iter = multiConditionNode.get("conditions").getElements();
        while (iter.hasNext()) {
            JsonNode propertyCriteriaNode = (JsonNode)iter.next();
            PropertyCriteria pc = new PropertyCriteria();
            pc.setOp(Op.valueOf(JsonUtils.getJsonValue(propertyCriteriaNode, "op")));
            pc.setProperty(JsonUtils.getJsonValue(propertyCriteriaNode, "property"));
            pc.setValue(JsonUtils.parseValue(propertyCriteriaNode));
            condition.addCondition(pc);
        }
        return condition;
    }

    private SimpleArithmetic parseSimpleArithmetic(JsonNode node) {
        JsonNode arithNode = node.get("arithmetic");
        if (arithNode == null) {
            return null;
        }
        SimpleArithmetic arith = new SimpleArithmetic();
        arith.setType(ArithmeticType.valueOf(JsonUtils.getJsonValue(arithNode, "type")));
        arith.setValue(this.parseSimpleArithmeticValue(arithNode));
        return arith;
    }

    private SimpleArithmeticValue parseSimpleArithmeticValue(JsonNode node) {
        JsonNode valueNode = node.get("value");
        SimpleArithmeticValue value = new SimpleArithmeticValue();
        value.setContent(valueNode.get("content").getTextValue());
        value.setArithmetic(this.parseSimpleArithmetic(valueNode));
        return value;
    }
}

