/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.NodeType;
import com.bstek.urule.runtime.rete.Activity;
import com.bstek.urule.runtime.rete.ObjectTypeActivity;
import java.util.Map;

public class ObjectTypeNode
extends BaseReteNode {
    public static final String NON_CLASS = "*";
    private String objectTypeClass;
    private NodeType nodeType = NodeType.objectType;

    public ObjectTypeNode() {
        super(0);
    }

    public ObjectTypeNode(String objectTypeClass, int id) {
        super(id);
        this.objectTypeClass = objectTypeClass;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean support(Object object) {
        return this.support(object.getClass().getName());
    }

    public boolean support(String className) {
        return this.objectTypeClass.equals(className);
    }

    public String getObjectTypeClass() {
        return this.objectTypeClass;
    }

    public void setObjectTypeClass(String objectTypeClass) {
        this.objectTypeClass = objectTypeClass;
    }

    @Override
    public Activity newActivity(Map<Object, Object> context) {
        Class<?> targetClass = null;
        ObjectTypeActivity activity = null;
        try {
            if (!this.objectTypeClass.equals(NON_CLASS)) {
                targetClass = Class.forName(this.objectTypeClass);
            }
            activity = new ObjectTypeActivity(targetClass);
        }
        catch (ClassNotFoundException e) {
            activity = new ObjectTypeActivity(this.objectTypeClass);
        }
        for (Line line : this.lines) {
            activity.addPath(line.newPath(context));
        }
        return activity;
    }
}

