/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rete.jsondeserializer.CommonFunctionValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ConstantValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.InputValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.MethodValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.NameReferenceValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ParameterValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ParenValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.VariableCategoryValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.VariableValueDeserializer;
import com.bstek.urule.model.rule.ArithmeticType;
import com.bstek.urule.model.rule.ComplexArithmetic;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.ValueType;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonUtils {
    private static List<ValueDeserializer> valueDeserializers = new ArrayList<ValueDeserializer>();

    public static String getJsonValue(JsonNode node, String propName) {
        if (node.get(propName) != null) {
            return node.get(propName).asText();
        }
        return null;
    }

    public static ComplexArithmetic parseComplexArithmetic(JsonNode node) {
        JsonNode arithmeticNode = node.get("arithmetic");
        if (arithmeticNode == null) {
            return null;
        }
        ComplexArithmetic arith = new ComplexArithmetic();
        arith.setType(ArithmeticType.valueOf(JsonUtils.getJsonValue(arithmeticNode, "type")));
        arith.setValue(JsonUtils.parseValue(arithmeticNode));
        return arith;
    }

    public static List<Parameter> parseParameters(JsonNode node) {
        JsonNode parametersNode = node.get("parameters");
        if (parametersNode == null) {
            return null;
        }
        Iterator iter = parametersNode.iterator();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        while (iter.hasNext()) {
            String valueTypeText;
            JsonNode parameterNode = (JsonNode)iter.next();
            Parameter param = new Parameter();
            param.setName(JsonUtils.getJsonValue(parameterNode, "name"));
            String type = JsonUtils.getJsonValue(parameterNode, "type");
            if (type != null) {
                param.setType(Datatype.valueOf(type));
            }
            if ((valueTypeText = JsonUtils.getJsonValue(parameterNode, "valueType")) != null) {
                param.setValue(JsonUtils.parseValue(parameterNode));
            }
            param.setValue(JsonUtils.parseValue(parameterNode));
            parameters.add(param);
        }
        return parameters;
    }

    public static Value parseValueNode(JsonNode valueNode) {
        Value value = null;
        ValueType valueType = ValueType.valueOf(JsonUtils.getJsonValue(valueNode, "valueType"));
        for (ValueDeserializer des : valueDeserializers) {
            if (!des.support(valueType)) continue;
            value = des.deserialize(valueNode);
            break;
        }
        return value;
    }

    public static KnowledgePackageWrapper parseKnowledgePackageWrapper(String content) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.getDeserializationConfig().withDateFormat((DateFormat)new SimpleDateFormat(Configure.getDateFormat()));
            KnowledgePackageWrapper wrapper = (KnowledgePackageWrapper)mapper.readValue(content, KnowledgePackageWrapper.class);
            wrapper.buildDeserialize();
            return wrapper;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    public static CommonFunctionParameter parseCommonFunctionParameter(JsonNode node) {
        JsonNode parameterNode = node.get("parameter");
        if (parameterNode == null) {
            return null;
        }
        CommonFunctionParameter parameter = new CommonFunctionParameter();
        parameter.setName(JsonUtils.getJsonValue(parameterNode, "name"));
        parameter.setProperty(JsonUtils.getJsonValue(parameterNode, "property"));
        parameter.setPropertyLabel(JsonUtils.getJsonValue(parameterNode, "propertyLabel"));
        parameter.setObjectParameter(JsonUtils.parseValueNode(parameterNode.get("objectParameter")));
        return parameter;
    }

    public static Value parseValue(JsonNode node) {
        JsonNode valueNode = node.get("value");
        if (valueNode == null) {
            return null;
        }
        return JsonUtils.parseValueNode(valueNode);
    }

    public static List<ValueDeserializer> getValueDeserializers() {
        return valueDeserializers;
    }

    static {
        valueDeserializers.add(new ConstantValueDeserializer());
        valueDeserializers.add(new InputValueDeserializer());
        valueDeserializers.add(new ParameterValueDeserializer());
        valueDeserializers.add(new MethodValueDeserializer());
        valueDeserializers.add(new VariableCategoryValueDeserializer());
        valueDeserializers.add(new VariableValueDeserializer());
        valueDeserializers.add(new CommonFunctionValueDeserializer());
        valueDeserializers.add(new ParenValueDeserializer());
        valueDeserializers.add(new NameReferenceValueDeserializer());
    }
}

