/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.library;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.library.action.ActionLibrary;
import com.bstek.urule.model.library.constant.ConstantCategory;
import com.bstek.urule.model.library.constant.ConstantLibrary;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.library.variable.VariableLibrary;
import java.util.ArrayList;
import java.util.List;

public class ResourceLibrary {
    private List<ConstantCategory> constantCategories;
    private List<ActionLibrary> actionLibraries;
    private List<VariableCategory> variableCategories;

    public ResourceLibrary() {
    }

    public ResourceLibrary(List<VariableLibrary> variableLibraries, List<ActionLibrary> actionLibraries, List<ConstantLibrary> constantLibraries) {
        this.variableCategories = new ArrayList<VariableCategory>();
        this.actionLibraries = new ArrayList<ActionLibrary>();
        this.constantCategories = new ArrayList<ConstantCategory>();
        for (VariableLibrary vl : variableLibraries) {
            for (VariableCategory category : vl.getVariableCategories()) {
                this.variableCategories.add(category);
            }
        }
        this.actionLibraries.addAll(actionLibraries);
        for (ConstantLibrary cl : constantLibraries) {
            for (ConstantCategory cc : cl.getCategories()) {
                this.constantCategories.add(cc);
            }
        }
    }

    public VariableCategory getVariableCategory(String categoryName) {
        for (VariableCategory category : this.variableCategories) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        throw new RuleException("Variable category [" + categoryName + "] not exist");
    }

    public List<ActionLibrary> getActionLibraries() {
        return this.actionLibraries;
    }

    public List<VariableCategory> getVariableCategories() {
        return this.variableCategories;
    }

    public List<ConstantCategory> getConstantCategories() {
        return this.constantCategories;
    }
}

