/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.library;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.model.library.HashMapTypeReference;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public enum Datatype {
    String,
    Integer,
    Char,
    Double,
    Long,
    Float,
    BigDecimal,
    Boolean,
    Date,
    List,
    Set,
    Map,
    Enum,
    Object;


    public String convertObjectToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value.toString();
        }
        switch (this) {
            case Object: {
                return value.toString();
            }
            case Date: {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sd.format((Date)value);
            }
            case List: {
                List list = (List)value;
                String a = "";
                for (int i = 0; i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (i > 0) {
                        a = a + ",";
                    }
                    a = a + obj;
                }
                return a;
            }
            case Set: {
                Set set = (Set)value;
                String b = "";
                int i = 0;
                for (Object obj : set) {
                    if (i > 0) {
                        b = b + ",";
                    }
                    b = b + obj;
                    ++i;
                }
                return b;
            }
            case BigDecimal: {
                BigDecimal bb = Utils.toBigDecimal(value);
                return bb.floatValue() + "";
            }
            case Double: {
                Double d = Utils.toBigDecimal(value).doubleValue();
                return d.floatValue() + "";
            }
        }
        return value.toString();
    }

    public Object convert(Object value) {
        switch (this) {
            case Object: {
                return value;
            }
            case String: {
                if (value == null) {
                    return value;
                }
                return value.toString();
            }
            case Integer: {
                if (value == null || value.toString().equals("")) {
                    value = "0";
                }
                return Utils.toBigDecimal(value).intValue();
            }
            case Char: {
                if (value == null) {
                    return Character.valueOf('\u0000');
                }
                if (value instanceof Character) {
                    return (Character)value;
                }
                String str = value.toString();
                if (str.length() == 1) {
                    return Character.valueOf(str.toCharArray()[0]);
                }
                int intValue = Utils.toBigDecimal(value).intValue();
                return Character.valueOf((char)intValue);
            }
            case Double: {
                if (value == null) {
                    value = "0";
                }
                return Utils.toBigDecimal(value).doubleValue();
            }
            case Long: {
                if (value == null) {
                    value = "0";
                }
                return Utils.toBigDecimal(value).longValue();
            }
            case Float: {
                if (value == null) {
                    value = "0";
                }
                return java.lang.Float.valueOf(Utils.toBigDecimal(value).floatValue());
            }
            case BigDecimal: {
                if (value == null) {
                    value = "0";
                }
                return Utils.toBigDecimal(value);
            }
            case Boolean: {
                if (value == null) {
                    value = "false";
                }
                return java.lang.Boolean.valueOf(value.toString());
            }
            case Date: {
                if (value == null) {
                    return null;
                }
                try {
                    if (value instanceof Date) {
                        return (Date)value;
                    }
                    if (value.toString().equals("")) {
                        return null;
                    }
                    try {
                        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        return sd.parse(value.toString());
                    }
                    catch (Exception ex) {
                        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                        return sd.parse(value.toString());
                    }
                }
                catch (ParseException e) {
                    throw new RuleException(e);
                }
            }
            case List: {
                String[] values;
                if (value == null) {
                    return null;
                }
                if (value instanceof List) {
                    return (List)value;
                }
                ArrayList<String> list = new ArrayList<String>();
                for (String v : values = value.toString().split(",")) {
                    list.add(v);
                }
                return list;
            }
            case Set: {
                if (value == null) {
                    return null;
                }
                if (value instanceof Set) {
                    return (Set)value;
                }
                TreeSet<String> set = new TreeSet<String>();
                for (String v : value.toString().split(",")) {
                    set.add(v);
                }
                return set;
            }
            case Map: {
                if (value == null) {
                    return null;
                }
                if (value instanceof Map) {
                    return (Map)value;
                }
                ObjectMapper mapper = new ObjectMapper();
                try {
                    Map map = (Map)mapper.readValue(value.toString(), (TypeReference)new HashMapTypeReference());
                    return map;
                }
                catch (Exception e) {
                    throw new RuleException(e);
                }
            }
            case Enum: {
                return value;
            }
        }
        return null;
    }
}

