/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow.ins;

import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.ProcessDefinition;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class FlowInstance
implements ProcessInstance {
    private String id;
    private int parallelInstanceCount;
    private ProcessDefinition flowDefinition;
    private FlowInstance parent;
    private List<ProcessInstance> children = new ArrayList<ProcessInstance>();
    private FlowNode currentNode;
    private boolean debug;

    public FlowInstance(ProcessDefinition flowDefinition, boolean debug) {
        this.flowDefinition = flowDefinition;
        this.id = UUID.randomUUID().toString();
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        return this.flowDefinition;
    }

    @Override
    public List<ProcessInstance> getChildren() {
        return this.children;
    }

    public void addChild(FlowInstance child) {
        this.children.add(child);
    }

    @Override
    public int getParallelInstanceCount() {
        return this.parallelInstanceCount;
    }

    public void setParallelInstanceCount(int parallelInstanceCount) {
        this.parallelInstanceCount = parallelInstanceCount;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FlowNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(FlowNode currentNode) {
        this.currentNode = currentNode;
    }

    public void setParent(FlowInstance parent) {
        this.parent = parent;
    }

    @Override
    public FlowInstance getParent() {
        return this.parent;
    }

    public FlowInstance newChildInstance(int childCount) {
        FlowInstance instance = new FlowInstance(this.flowDefinition, this.debug);
        instance.setParallelInstanceCount(childCount);
        instance.setParent(this);
        this.addChild(instance);
        return instance;
    }
}

