/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.model.flow.BindingNode;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import java.util.List;

public class ScriptNode
extends BindingNode {
    private String script;
    private FlowNodeType type = FlowNodeType.Script;

    @Override
    public void enterNode(FlowContext context, FlowInstance instance) {
        instance.setCurrentNode(this);
        this.executeNodeEvent(EventType.enter, context, instance);
        this.executeKnowledgePackage(context, instance);
        this.executeNodeEvent(EventType.leave, context, instance);
        this.leave(null, context, instance);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    public String buildDSLScript(List<Library> libraries) {
        StringBuffer sb = new StringBuffer();
        if (libraries != null) {
            for (Library lib : libraries) {
                String path = lib.getPath();
                if (lib.getVersion() != null) {
                    path = path + ":" + lib.getVersion();
                }
                LibraryType type = lib.getType();
                switch (type) {
                    case Action: {
                        sb.append("importActionLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Constant: {
                        sb.append("importConstantLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Parameter: {
                        sb.append("importParameterLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Variable: {
                        sb.append("importVariableLibrary \"" + path + "\"");
                        sb.append("\r\n");
                    }
                }
            }
        }
        sb.append("rule \"sr\" ");
        sb.append(" ");
        sb.append("if");
        sb.append(" ");
        sb.append("then");
        sb.append(" ");
        if (this.script != null) {
            sb.append(this.script);
        }
        sb.append(" ");
        sb.append("end");
        sb.append(" ");
        return sb.toString();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }
}

