/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;

public class JoinNode
extends FlowNode {
    private FlowNodeType type = FlowNodeType.Join;

    public JoinNode() {
    }

    public JoinNode(String name) {
        super(name);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    @Override
    public void enterNode(FlowContext context, FlowInstance instance) {
        instance.setCurrentNode(this);
        this.executeNodeEvent(EventType.enter, context, instance);
        FlowInstance parentInstance = instance.getParent();
        if (parentInstance == null) {
            throw new RuleException("Invalid flow instance.");
        }
        String id = parentInstance.getId();
        int arrivedChild = 1;
        if (context.getVariable(id) == null) {
            context.addVariable(id, arrivedChild);
        } else {
            arrivedChild = (Integer)context.getVariable(id);
            context.addVariable(id, ++arrivedChild);
        }
        this.executeNodeEvent(EventType.leave, context, instance);
        int childCount = instance.getParallelInstanceCount();
        if (arrivedChild >= childCount) {
            context.removeVariable(id);
            this.leave(null, context, parentInstance);
        }
    }
}

