/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import java.util.ArrayList;

public class ForkNode
extends FlowNode {
    private FlowNodeType type = FlowNodeType.Fork;

    public ForkNode() {
    }

    public ForkNode(String name) {
        super(name);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    @Override
    public void enterNode(FlowContext context, FlowInstance instance) {
        instance.setCurrentNode(this);
        this.executeNodeEvent(EventType.enter, context, instance);
        ArrayList<Connection> forkConnections = new ArrayList<Connection>();
        for (Connection connection : this.connections) {
            if (!connection.evaluate(context)) continue;
            forkConnections.add(connection);
        }
        this.executeNodeEvent(EventType.leave, context, instance);
        int childCount = forkConnections.size();
        for (Connection connection : forkConnections) {
            FlowInstance newChildInstance = instance.newChildInstance(childCount);
            connection.execute(context, newChildInstance);
        }
    }
}

