/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.model.flow.ActionNode;
import com.bstek.urule.model.flow.BindingNode;
import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.DecisionItem;
import com.bstek.urule.model.flow.DecisionNode;
import com.bstek.urule.model.flow.DecisionType;
import com.bstek.urule.model.flow.EndNode;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ForkNode;
import com.bstek.urule.model.flow.JoinNode;
import com.bstek.urule.model.flow.RuleNode;
import com.bstek.urule.model.flow.RulePackageNode;
import com.bstek.urule.model.flow.ScriptNode;
import com.bstek.urule.model.flow.StartNode;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;

public class FlowNodeJsonDeserializer
extends JsonDeserializer<List<FlowNode>> {
    public List<FlowNode> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode jsonNode = mapper.readTree(jsonParser);
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        Iterator childrenNodesIter = jsonNode.getElements();
        while (childrenNodesIter.hasNext()) {
            JsonNode knowledgePackageWrapperNode;
            JsonNode connectionsNode;
            JsonNode childNode = (JsonNode)childrenNodesIter.next();
            JsonNode type = childNode.get("type");
            if (type == null) continue;
            FlowNode node = null;
            FlowNodeType nodeType = FlowNodeType.valueOf(type.getTextValue());
            switch (nodeType) {
                case Action: {
                    ActionNode actionNode = new ActionNode();
                    JsonNode actionBeanNode = childNode.get("actionBean");
                    if (actionBeanNode != null) {
                        actionNode.setActionBean(actionBeanNode.getTextValue());
                    }
                    node = actionNode;
                    break;
                }
                case Script: {
                    ScriptNode scriptNode = new ScriptNode();
                    JsonNode sn = childNode.get("script");
                    if (sn != null) {
                        scriptNode.setScript(sn.getTextValue());
                    }
                    node = scriptNode;
                    break;
                }
                case Decision: {
                    DecisionNode decisionNode = new DecisionNode();
                    DecisionType decisionType = DecisionType.valueOf(childNode.get("decisionType").getTextValue());
                    decisionNode.setDecisionType(decisionType);
                    JsonNode itemsNode = childNode.get("items");
                    Iterator iter = itemsNode.getElements();
                    ArrayList<DecisionItem> items = new ArrayList<DecisionItem>();
                    while (iter.hasNext()) {
                        JsonNode itemNode = (JsonNode)iter.next();
                        DecisionItem item = new DecisionItem();
                        item.setTo(itemNode.get("to").getTextValue());
                        if (decisionType.equals((Object)DecisionType.Criteria)) {
                            item.setScript(itemNode.get("script").getTextValue());
                        } else {
                            item.setPercent(itemNode.get("percent").getIntValue());
                        }
                        items.add(item);
                    }
                    decisionNode.setItems(items);
                    node = decisionNode;
                    break;
                }
                case End: {
                    node = new EndNode();
                    break;
                }
                case Fork: {
                    node = new ForkNode();
                    break;
                }
                case Join: {
                    node = new JoinNode();
                    break;
                }
                case Rule: {
                    RuleNode ruleNode = new RuleNode();
                    ruleNode.setFile(childNode.get("file").getTextValue());
                    JsonNode versionNode = childNode.get("version");
                    if (versionNode != null) {
                        ruleNode.setVersion(versionNode.getTextValue());
                    }
                    node = ruleNode;
                    break;
                }
                case RulePackage: {
                    RulePackageNode packageNode = new RulePackageNode();
                    packageNode.setPackageId(childNode.get("packageId").getTextValue());
                    if (childNode.get("project") != null) {
                        packageNode.setPackageId(childNode.get("project").getTextValue());
                    }
                    node = packageNode;
                    break;
                }
                case Start: {
                    node = new StartNode();
                }
            }
            String name = childNode.get("name").getTextValue();
            node.setName(name);
            JsonNode eventNode = childNode.get("eventBean");
            if (eventNode != null) {
                node.setEventBean(eventNode.getTextValue());
            }
            if ((connectionsNode = childNode.get("connections")) != null) {
                ArrayList<Connection> connections = new ArrayList<Connection>();
                Iterator iter = connectionsNode.getElements();
                while (iter.hasNext()) {
                    JsonNode connNode = (JsonNode)iter.next();
                    Connection conn = (Connection)mapper.readValue(connNode, Connection.class);
                    connections.add(conn);
                }
                for (Connection conn : connections) {
                    conn.buildDeserialize();
                }
                node.setConnections(connections);
            }
            if ((knowledgePackageWrapperNode = childNode.get("knowledgePackageWrapper")) != null) {
                KnowledgePackageWrapper wrapper = (KnowledgePackageWrapper)mapper.readValue(knowledgePackageWrapperNode, KnowledgePackageWrapper.class);
                wrapper.buildDeserialize();
                BindingNode bindingNode = (BindingNode)node;
                bindingNode.setKnowledgePackageWrapper(wrapper);
            }
            flowNodes.add(node);
        }
        return flowNodes;
    }
}

