/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.Node;
import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.NodeEvent;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.event.impl.ProcessAfterNodeTriggeredEventImpl;
import com.bstek.urule.runtime.event.impl.ProcessBeforeNodeTriggeredEventImpl;
import com.bstek.urule.runtime.response.ExecutionResponseImpl;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;

public abstract class FlowNode
implements Node {
    protected String name;
    protected String eventBean;
    protected String x;
    protected String y;
    protected String width;
    protected String height;
    protected List<Connection> connections;

    public FlowNode() {
    }

    public FlowNode(String name) {
        this.name = name;
    }

    public final void enter(FlowContext context, FlowInstance instance) {
        String msg = ">>>\u8fdb\u5165\u51b3\u7b56\u6d41\u8282\u70b9\uff1a" + this.name;
        context.debugMsg(msg, MsgType.RuleFlow, instance.isDebug());
        ((ExecutionResponseImpl)context.getResponse()).addNodeName(this.name);
        KnowledgeSession session = (KnowledgeSession)context.getWorkingMemory();
        session.fireEvent(new ProcessBeforeNodeTriggeredEventImpl(this, instance, session));
        this.enterNode(context, instance);
        session.fireEvent(new ProcessAfterNodeTriggeredEventImpl(this, instance, session));
    }

    public abstract void enterNode(FlowContext var1, FlowInstance var2);

    protected void leave(String connectionName, FlowContext context, FlowInstance instance) {
        for (Connection connection : this.connections) {
            if (connectionName != null) {
                String cName = connection.getName();
                String string = cName = cName == null ? cName : cName.trim();
                if (!connectionName.trim().equals(cName)) continue;
                connection.execute(context, instance);
                break;
            }
            if (!connection.evaluate(context)) continue;
            connection.execute(context, instance);
            break;
        }
    }

    protected void executeNodeEvent(EventType type, FlowContext context, ProcessInstance instance) {
        if (StringUtils.isEmpty((String)this.eventBean)) {
            return;
        }
        ApplicationContext applicationContext = context.getApplicationContext();
        NodeEvent event = (NodeEvent)applicationContext.getBean(this.eventBean);
        if (type.equals((Object)EventType.enter)) {
            event.enter(this, instance, context);
        } else {
            event.leave(this, instance, context);
        }
    }

    public abstract FlowNodeType getType();

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEventBean() {
        return this.eventBean;
    }

    public void setEventBean(String eventBean) {
        this.eventBean = eventBean;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
}

