/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.RuleException;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.DecisionNode;
import com.bstek.urule.model.flow.DecisionType;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeJsonDeserializer;
import com.bstek.urule.model.flow.ForkNode;
import com.bstek.urule.model.flow.ProcessDefinition;
import com.bstek.urule.model.flow.RuleNode;
import com.bstek.urule.model.flow.RulePackageNode;
import com.bstek.urule.model.flow.ScriptNode;
import com.bstek.urule.model.flow.StartNode;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.event.impl.ProcessBeforeCompletedEventImpl;
import com.bstek.urule.runtime.event.impl.ProcessBeforeStartedEventImpl;
import com.bstek.urule.runtime.response.ExecutionResponseImpl;
import com.bstek.urule.runtime.service.KnowledgePackageService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public class FlowDefinition
implements ProcessDefinition {
    private String id;
    private boolean debug;
    @JsonIgnore
    private List<Library> libraries;
    @JsonDeserialize(using=FlowNodeJsonDeserializer.class)
    private List<FlowNode> nodes;

    public ProcessInstance newInstance(FlowContext context) {
        ExecutionResponseImpl response = (ExecutionResponseImpl)context.getResponse();
        response.setFlowId(this.id);
        FlowNode startNode = null;
        for (FlowNode node : this.nodes) {
            if (!(node instanceof StartNode)) continue;
            startNode = (StartNode)node;
            break;
        }
        if (startNode == null) {
            throw new RuleException("StartNode must be define.");
        }
        response.addNodeName(startNode.getName());
        FlowInstance instance = new FlowInstance(this, this.debug);
        KnowledgeSession session = (KnowledgeSession)context.getWorkingMemory();
        session.fireEvent(new ProcessBeforeStartedEventImpl(instance, session));
        startNode.enter(context, instance);
        session.fireEvent(new ProcessBeforeCompletedEventImpl(instance, session));
        return instance;
    }

    public void buildConnectionToNode() {
        for (FlowNode node : this.nodes) {
            List<Connection> connections = node.getConnections();
            if (connections == null || connections.size() == 0) continue;
            for (Connection conn : connections) {
                String nodeName = conn.getToName();
                conn.setTo(this.getFlowNode(nodeName));
            }
        }
    }

    private FlowNode getFlowNode(String nodeName) {
        for (FlowNode node : this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        throw new RuleException("Flow node [" + nodeName + "] not found.");
    }

    public void initNodeKnowledgePackage(KnowledgeBuilder knowledgeBuilder, KnowledgePackageService knowledgePackageService, DSLRuleSetBuilder dslRuleSetBuilder) throws IOException {
        for (FlowNode node : this.nodes) {
            KnowledgeBase knowledgeBase;
            RuleSet ruleSet;
            String script;
            if (node instanceof RuleNode) {
                ResourceBase resourceBase = knowledgeBuilder.newResourceBase();
                RuleNode ruleNode = (RuleNode)node;
                resourceBase.addResource(ruleNode.getFile(), ruleNode.getVersion());
                KnowledgeBase knowledgeBase2 = knowledgeBuilder.buildKnowledgeBase(resourceBase);
                KnowledgePackage knowledgePackage = knowledgeBase2.getKnowledgePackage();
                ruleNode.setKnowledgePackageWrapper(new KnowledgePackageWrapper(knowledgePackage));
                continue;
            }
            if (node instanceof RulePackageNode) {
                RulePackageNode rulePackageNode = (RulePackageNode)node;
                String packageId = rulePackageNode.getProject() + "/" + rulePackageNode.getPackageId();
                KnowledgePackage knowledgePackage = knowledgePackageService.buildKnowledgePackage(packageId);
                rulePackageNode.setKnowledgePackageWrapper(new KnowledgePackageWrapper(knowledgePackage));
                continue;
            }
            if (node instanceof DecisionNode) {
                DecisionNode decisionNode = (DecisionNode)node;
                if (!decisionNode.getDecisionType().equals((Object)DecisionType.Criteria)) continue;
                script = decisionNode.buildDSLScript(this.libraries);
                ruleSet = dslRuleSetBuilder.build(script);
                knowledgeBase = knowledgeBuilder.buildKnowledgeBase(ruleSet);
                decisionNode.setKnowledgePackageWrapper(new KnowledgePackageWrapper(knowledgeBase.getKnowledgePackage()));
                continue;
            }
            if (node instanceof ScriptNode) {
                ScriptNode scriptNode = (ScriptNode)node;
                script = scriptNode.buildDSLScript(this.libraries);
                ruleSet = dslRuleSetBuilder.build(script);
                knowledgeBase = knowledgeBuilder.buildKnowledgeBase(ruleSet);
                scriptNode.setKnowledgePackageWrapper(new KnowledgePackageWrapper(knowledgeBase.getKnowledgePackage()));
                continue;
            }
            if (!(node instanceof ForkNode)) continue;
            List<Connection> connections = node.getConnections();
            for (Connection conn : connections) {
                String script2 = conn.getScript();
                if (script2 == null) continue;
                script2 = conn.buildDSLScript(this.libraries);
                RuleSet ruleSet2 = dslRuleSetBuilder.build(script2);
                KnowledgeBase knowledgeBase3 = knowledgeBuilder.buildKnowledgeBase(ruleSet2);
                conn.setKnowledgePackageWrapper(new KnowledgePackageWrapper(knowledgeBase3.getKnowledgePackage()));
            }
        }
    }

    public void addLibrary(Library lib) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<Library>();
        }
        this.libraries.add(lib);
    }

    @Override
    public List<Library> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<Library> libraries) {
        this.libraries = libraries;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<FlowNode> nodes) {
        this.nodes = nodes;
    }
}

