/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.model.flow.BindingNode;
import com.bstek.urule.model.flow.DecisionItem;
import com.bstek.urule.model.flow.DecisionType;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.PercentItem;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.runtime.KnowledgeSession;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DecisionNode
extends BindingNode {
    private final Logger log = Logger.getLogger(DecisionNode.class.getName());
    private List<DecisionItem> items;
    private FlowNodeType type = FlowNodeType.Decision;
    private DecisionType decisionType = DecisionType.Criteria;

    public DecisionNode() {
    }

    public DecisionNode(String name) {
        super(name);
    }

    @Override
    public void enterNode(FlowContext context, FlowInstance instance) {
        instance.setCurrentNode(this);
        if (this.decisionType.equals((Object)DecisionType.Criteria)) {
            this.doCriteria(context, instance);
        } else {
            this.doPercent(context, instance);
        }
        this.executeNodeEvent(EventType.enter, context, instance);
    }

    private void doPercent(FlowContext context, FlowInstance instance) {
        String nodeKey = instance.getProcessDefinition().getId() + "_" + this.getName();
        long total = this.getAmount(nodeKey, context) + 1L;
        ArrayList<PercentItem> percentItems = new ArrayList<PercentItem>();
        for (DecisionItem item : this.items) {
            PercentItem percent = new PercentItem();
            percent.setName(item.getTo());
            percent.setPercent(item.getPercent());
            String itemKey = nodeKey + "." + item.getTo();
            long itemTotal = this.getAmount(itemKey, context);
            percent.setTotal(itemTotal);
            percentItems.add(percent);
        }
        PercentItem percentItem = this.computePercent(percentItems, total);
        this.setAmount(nodeKey, total, context);
        this.setAmount(nodeKey + "." + percentItem.getName(), percentItem.getTotal() + 1L, context);
        this.executeNodeEvent(EventType.leave, context, instance);
        this.leave(percentItem.getName(), context, instance);
    }

    private long getAmount(String key, FlowContext context) {
        Object value = context.getSessionValue(key);
        if (value == null) {
            return 0L;
        }
        return (Long)value;
    }

    private void setAmount(String key, long value, FlowContext context) {
        context.setSessionValue(key, value);
    }

    private void doCriteria(FlowContext context, FlowInstance instance) {
        KnowledgeSession session = this.executeKnowledgePackage(context, instance);
        this.executeNodeEvent(EventType.leave, context, instance);
        Object to = session.getParameter("return_to__");
        if (to == null) {
            this.log.info("Decision node [" + this.getName() + "] no matching conditions.");
            return;
        }
        session.getParameters().remove("return_to__");
        this.leave(to.toString(), context, instance);
    }

    private PercentItem computePercent(List<PercentItem> items, long total) {
        BigDecimal totalValue = new BigDecimal(total);
        for (PercentItem item : items) {
            long itemTotal = item.getTotal();
            BigDecimal left = new BigDecimal(itemTotal);
            BigDecimal newPercent = left.divide(totalValue, 20, 6);
            BigDecimal defaultPercent = new BigDecimal(item.getPercent());
            int result = newPercent.compareTo(defaultPercent = defaultPercent.divide(new BigDecimal(100), 2, 6));
            if (result != -1) continue;
            return item;
        }
        return items.get(0);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    public List<DecisionItem> getItems() {
        return this.items;
    }

    public void setItems(List<DecisionItem> items) {
        this.items = items;
    }

    public String buildDSLScript(List<Library> libraries) {
        StringBuffer sb = new StringBuffer();
        if (libraries != null) {
            for (Library lib : libraries) {
                String path = lib.getPath();
                if (lib.getVersion() != null) {
                    path = path + ":" + lib.getVersion();
                }
                LibraryType type = lib.getType();
                switch (type) {
                    case Action: {
                        sb.append("importActionLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Constant: {
                        sb.append("importConstantLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Parameter: {
                        sb.append("importParameterLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Variable: {
                        sb.append("importVariableLibrary \"" + path + "\"");
                        sb.append("\r\n");
                    }
                }
            }
        }
        for (int i = 0; i < this.items.size(); ++i) {
            DecisionItem item = this.items.get(i);
            sb.append(item.buildDSLScript(i));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public DecisionType getDecisionType() {
        return this.decisionType;
    }

    public void setDecisionType(DecisionType decisionType) {
        this.decisionType = decisionType;
    }
}

