/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Connection {
    public static final String RETURN_VALUE_KEY = "return_value__";
    private String name;
    private String toName;
    private String script;
    private String g;
    private KnowledgePackageWrapper knowledgePackageWrapper;
    @JsonIgnore
    private FlowNode to;

    public boolean evaluate(FlowContext context) {
        if (this.knowledgePackageWrapper == null) {
            return true;
        }
        KnowledgeSession parentSession = (KnowledgeSession)context.getWorkingMemory();
        List<Object> facts = parentSession.getAllFacts();
        KnowledgeSession session = KnowledgeSessionFactory.newKnowledgeSession(this.knowledgePackageWrapper.getKnowledgePackage(), context.getDebugMessageItems());
        for (Object fact : facts) {
            session.insert(fact);
        }
        session.fireRules(context.getVariables());
        Object result = session.getParameter(RETURN_VALUE_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.valueOf(result.toString());
    }

    public void buildDeserialize() {
        if (this.knowledgePackageWrapper != null) {
            this.knowledgePackageWrapper.buildDeserialize();
        }
    }

    public void execute(FlowContext context, FlowInstance instance) {
        this.to.enter(context, instance);
    }

    public String buildDSLScript(List<Library> libraries) {
        StringBuffer sb = new StringBuffer();
        if (libraries != null) {
            for (Library lib : libraries) {
                String path = lib.getPath();
                if (lib.getVersion() != null) {
                    path = path + ":" + lib.getVersion();
                }
                LibraryType type = lib.getType();
                switch (type) {
                    case Action: {
                        sb.append("importActionLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Constant: {
                        sb.append("importConstantLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Parameter: {
                        sb.append("importParameterLibrary \"" + path + "\"");
                        sb.append("\r\n");
                        break;
                    }
                    case Variable: {
                        sb.append("importVariableLibrary \"" + path + "\"");
                        sb.append("\r\n");
                    }
                }
            }
        }
        sb.append("rule \"conn\"");
        sb.append("\r\n");
        sb.append("if");
        sb.append("\r\n");
        sb.append(this.script);
        sb.append("\r\n");
        sb.append("then");
        sb.append("\r\n");
        sb.append("parameter.return_value__=true");
        sb.append("\r\n");
        sb.append("end");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public FlowNode getTo() {
        return this.to;
    }

    public void setTo(FlowNode to) {
        this.to = to;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public KnowledgePackageWrapper getKnowledgePackageWrapper() {
        return this.knowledgePackageWrapper;
    }

    public void setKnowledgePackageWrapper(KnowledgePackageWrapper knowledgePackageWrapper) {
        this.knowledgePackageWrapper = knowledgePackageWrapper;
    }

    public String getG() {
        return this.g;
    }

    public void setG(String g) {
        this.g = g;
    }
}

