/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dsl.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.dsl.DSLUtils;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.dsl.builder.BuildUtils;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.CriteriaUnit;
import com.bstek.urule.model.rule.lhs.JunctionType;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import java.util.ArrayList;
import java.util.List;

public class NamedConditionBuilder {
    public CriteriaUnit buildNamedCriteria(RuleParserParser.NamedConditionContext namedConditionContext, String variableCategory) {
        CriteriaUnit unit = null;
        if (namedConditionContext instanceof RuleParserParser.MultiNamedConditionsContext) {
            unit = this.visitMultiNamedConditions((RuleParserParser.MultiNamedConditionsContext)namedConditionContext, variableCategory);
        } else if (namedConditionContext instanceof RuleParserParser.SingleNamedConditionsContext) {
            unit = this.visitSingleNamedConditions((RuleParserParser.SingleNamedConditionsContext)namedConditionContext, variableCategory);
        } else if (namedConditionContext instanceof RuleParserParser.ParenNamedConditionsContext) {
            unit = this.visitParenNamedConditions((RuleParserParser.ParenNamedConditionsContext)namedConditionContext, variableCategory);
        } else {
            throw new RuleException("Unsupport context : +namedConditionContext+");
        }
        return unit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CriteriaUnit visitSingleNamedConditions(RuleParserParser.SingleNamedConditionsContext ctx, String variableCategory) {
        Criteria criteria = new Criteria();
        VariableLeftPart leftPart = new VariableLeftPart();
        Left left = new Left();
        left.setLeftPart(leftPart);
        left.setType(LeftType.NamedReference);
        criteria.setLeft(left);
        String variableName = ctx.property().getText();
        leftPart.setVariableLabel(variableName);
        leftPart.setVariableCategory(variableCategory);
        Op op = DSLUtils.parseOp(ctx.op());
        criteria.setOp(op);
        if (ctx.complexValue() == null) {
            if (op.equals((Object)Op.Equals)) {
                criteria.setOp(Op.Null);
            } else {
                if (!op.equals((Object)Op.NotEquals)) throw new RuleException("'null' value only support '==' or '!=' operator.");
                criteria.setOp(Op.NotNull);
            }
        } else {
            criteria.setValue(BuildUtils.buildValue(ctx.complexValue()));
        }
        CriteriaUnit unit = new CriteriaUnit();
        unit.setCriteria(criteria);
        return unit;
    }

    private CriteriaUnit visitMultiNamedConditions(RuleParserParser.MultiNamedConditionsContext ctx, String variableCategory) {
        ArrayList<CriteriaUnit> nextUnits = new ArrayList<CriteriaUnit>();
        List<RuleParserParser.NamedConditionContext> namedConditions = ctx.namedCondition();
        if (namedConditions != null) {
            for (int i = 0; i < namedConditions.size(); ++i) {
                RuleParserParser.NamedConditionContext context = namedConditions.get(i);
                CriteriaUnit nextUnit = this.buildNamedCriteria(context, variableCategory);
                nextUnits.add(nextUnit);
                RuleParserParser.JoinContext joinContext = ctx.join(i);
                if (joinContext == null) continue;
                if (joinContext.AND() != null) {
                    nextUnit.setJunctionType(JunctionType.and);
                    continue;
                }
                nextUnit.setJunctionType(JunctionType.or);
            }
        }
        CriteriaUnit unit = new CriteriaUnit();
        unit.setNextUnits(nextUnits);
        return unit;
    }

    private CriteriaUnit visitParenNamedConditions(RuleParserParser.ParenNamedConditionsContext ctx, String variableCategory) {
        RuleParserParser.NamedConditionContext namedConditionContext = ctx.namedCondition();
        CriteriaUnit unit = this.buildNamedCriteria(namedConditionContext, variableCategory);
        return unit;
    }
}

