/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dsl.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.dsl.DSLUtils;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.dsl.builder.AbstractContextBuilder;
import com.bstek.urule.dsl.builder.BuildUtils;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.lhs.AbstractLeftPart;
import com.bstek.urule.model.rule.lhs.AllLeftPart;
import com.bstek.urule.model.rule.lhs.CollectLeftPart;
import com.bstek.urule.model.rule.lhs.CollectPurpose;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.EvalLeftPart;
import com.bstek.urule.model.rule.lhs.ExistLeftPart;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.JunctionType;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.MultiCondition;
import com.bstek.urule.model.rule.lhs.PropertyCriteria;
import com.bstek.urule.model.rule.lhs.StatisticType;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CriteriaContextBuilder
extends AbstractContextBuilder
implements ApplicationContextAware {
    private Collection<FunctionDescriptor> functionDescriptors;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Criteria build(ParserRuleContext context) {
        RuleParserParser.VariableContext vc;
        LeftPart part;
        RuleParserParser.SingleConditionContext ctx = (RuleParserParser.SingleConditionContext)context;
        RuleParserParser.ConditionLeftContext conditionLeftContext = ctx.conditionLeft();
        RuleParserParser.VariableContext variableContext = conditionLeftContext.variable();
        RuleParserParser.ParameterContext parameterContext = conditionLeftContext.parameter();
        RuleParserParser.FunctionInvokeContext functionInvokeContext = conditionLeftContext.functionInvoke();
        RuleParserParser.CommonFunctionContext commonFunctionContext = conditionLeftContext.commonFunction();
        RuleParserParser.MethodInvokeContext methodInvokeContext = conditionLeftContext.methodInvoke();
        RuleParserParser.ExpEvalContext expEvalContext = conditionLeftContext.expEval();
        RuleParserParser.ExpAllContext expAllContext = conditionLeftContext.expAll();
        RuleParserParser.ExpExistsContext expExistsContext = conditionLeftContext.expExists();
        RuleParserParser.ExpCollectContext expCollectContext = conditionLeftContext.expCollect();
        Criteria criteria = new Criteria();
        Left left = new Left();
        LeftPart leftPart = null;
        String variableCategory = null;
        String variableLabel = null;
        if (variableContext != null) {
            variableCategory = variableContext.variableCategory().Identifier().getText();
            variableLabel = variableContext.property().getText();
            part = new VariableLeftPart();
            ((VariableLeftPart)part).setVariableCategory(variableCategory);
            ((VariableLeftPart)part).setVariableLabel(variableLabel);
            left.setType(LeftType.variable);
            leftPart = part;
        } else if (parameterContext != null) {
            variableCategory = "\u53c2\u6570";
            variableLabel = parameterContext.Identifier().getText();
            part = new VariableLeftPart();
            ((VariableLeftPart)part).setVariableCategory(variableCategory);
            ((VariableLeftPart)part).setVariableLabel(variableLabel);
            left.setType(LeftType.variable);
            leftPart = part;
        } else if (functionInvokeContext != null) {
            part = new FunctionLeftPart();
            String name = functionInvokeContext.Identifier().getText();
            RuleParserParser.ActionParametersContext parametersContext = functionInvokeContext.actionParameters();
            if (parametersContext != null) {
                ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                for (RuleParserParser.ComplexValueContext complexValueContext : parametersContext.complexValue()) {
                    Parameter parameter = new Parameter();
                    parameter.setValue(BuildUtils.buildValue(complexValueContext));
                    parameters.add(parameter);
                }
                ((FunctionLeftPart)part).setParameters(parameters);
            }
            ((FunctionLeftPart)part).setName(name);
            left.setType(LeftType.function);
            leftPart = part;
        } else if (commonFunctionContext != null) {
            part = new CommonFunctionLeftPart();
            String nameorlabel = commonFunctionContext.Identifier().getText();
            for (FunctionDescriptor fun : this.functionDescriptors) {
                if (nameorlabel.equals(fun.getName())) {
                    ((CommonFunctionLeftPart)part).setName(fun.getName());
                    ((CommonFunctionLeftPart)part).setLabel(fun.getLabel());
                    break;
                }
                if (!nameorlabel.equals(fun.getLabel())) continue;
                ((CommonFunctionLeftPart)part).setName(fun.getName());
                ((CommonFunctionLeftPart)part).setLabel(fun.getLabel());
                break;
            }
            if (((CommonFunctionLeftPart)part).getName() == null) {
                throw new RuleException("Function[" + nameorlabel + "] not exist.");
            }
            RuleParserParser.ComplexValueContext value = commonFunctionContext.complexValue();
            CommonFunctionParameter param = new CommonFunctionParameter();
            param.setObjectParameter(BuildUtils.buildValue(value));
            RuleParserParser.PropertyContext propertyContext = commonFunctionContext.property();
            if (propertyContext != null) {
                param.setProperty(propertyContext.getText());
            }
            ((CommonFunctionLeftPart)part).setParameter(param);
            left.setType(LeftType.commonfunction);
            leftPart = part;
        } else if (methodInvokeContext != null) {
            part = new MethodLeftPart();
            RuleParserParser.BeanMethodContext beanMethodContext = methodInvokeContext.beanMethod();
            String beanLabel = beanMethodContext.Identifier(0).getText();
            String methodLabel = beanMethodContext.Identifier(1).getText();
            ((MethodLeftPart)part).setBeanLabel(beanLabel);
            ((MethodLeftPart)part).setMethodLabel(methodLabel);
            RuleParserParser.ActionParametersContext parametersContext = methodInvokeContext.actionParameters();
            if (parametersContext != null) {
                ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                for (RuleParserParser.ComplexValueContext complexValueContext : parametersContext.complexValue()) {
                    Parameter parameter = new Parameter();
                    parameter.setValue(BuildUtils.buildValue(complexValueContext));
                    parameters.add(parameter);
                }
                ((MethodLeftPart)part).setParameters(parameters);
            }
            left.setType(LeftType.method);
            leftPart = part;
        } else if (expEvalContext != null) {
            part = new EvalLeftPart();
            RuleParserParser.ExpressionBodyContext bodyContext = expEvalContext.expressionBody();
            ((EvalLeftPart)part).setExpression(bodyContext.getText());
            left.setType(LeftType.eval);
            leftPart = part;
        } else if (expAllContext != null) {
            part = new AllLeftPart();
            vc = expAllContext.variable();
            RuleParserParser.ParameterContext pc = expAllContext.parameter();
            if (vc != null) {
                ((AbstractLeftPart)part).setVariableCategory(vc.variableCategory().getText());
                ((AbstractLeftPart)part).setVariableLabel(vc.property().getText());
            } else if (pc != null) {
                ((AbstractLeftPart)part).setVariableCategory("\u53c2\u6570");
                ((AbstractLeftPart)part).setVariableLabel(pc.Identifier().getText());
            }
            TerminalNode numberNode = expAllContext.NUMBER();
            RuleParserParser.PercentContext percentContext = expAllContext.percent();
            if (numberNode != null) {
                ((AllLeftPart)part).setAmount(Integer.valueOf(numberNode.getText()));
                ((AllLeftPart)part).setStatisticType(StatisticType.amount);
            } else if (percentContext != null) {
                ((AllLeftPart)part).setPercent(Integer.valueOf(percentContext.NUMBER().getText()));
                ((AllLeftPart)part).setStatisticType(StatisticType.percent);
            } else {
                ((AllLeftPart)part).setStatisticType(StatisticType.none);
            }
            RuleParserParser.ExprConditionContext conditionContext = expAllContext.exprCondition();
            MultiCondition condition = this.buildMultiCondition(conditionContext);
            ((AbstractLeftPart)part).setMultiCondition(condition);
            left.setType(LeftType.all);
            leftPart = part;
        } else if (expExistsContext != null) {
            part = new ExistLeftPart();
            vc = expExistsContext.variable();
            RuleParserParser.ParameterContext pc = expExistsContext.parameter();
            if (vc != null) {
                ((AbstractLeftPart)part).setVariableCategory(vc.variableCategory().getText());
                ((AbstractLeftPart)part).setVariableLabel(vc.property().getText());
            } else if (pc != null) {
                ((AbstractLeftPart)part).setVariableCategory("\u53c2\u6570");
                ((AbstractLeftPart)part).setVariableLabel(pc.Identifier().getText());
            }
            TerminalNode numberNode = expExistsContext.NUMBER();
            RuleParserParser.PercentContext percentContext = expExistsContext.percent();
            if (numberNode != null) {
                ((AllLeftPart)part).setAmount(Integer.valueOf(numberNode.getText()));
                ((AllLeftPart)part).setStatisticType(StatisticType.amount);
            } else if (percentContext != null) {
                ((AllLeftPart)part).setPercent(Integer.valueOf(percentContext.NUMBER().getText()));
                ((AllLeftPart)part).setStatisticType(StatisticType.percent);
            } else {
                ((AllLeftPart)part).setStatisticType(StatisticType.none);
            }
            RuleParserParser.ExprConditionContext conditionContext = expExistsContext.exprCondition();
            MultiCondition condition = this.buildMultiCondition(conditionContext);
            ((AbstractLeftPart)part).setMultiCondition(condition);
            left.setType(LeftType.exist);
            leftPart = part;
        } else if (expCollectContext != null) {
            part = new CollectLeftPart();
            vc = expCollectContext.variable();
            RuleParserParser.ParameterContext pc = expCollectContext.parameter();
            if (vc != null) {
                ((AbstractLeftPart)part).setVariableCategory(vc.variableCategory().getText());
                ((AbstractLeftPart)part).setVariableLabel(vc.property().getText());
            } else if (pc != null) {
                ((AbstractLeftPart)part).setVariableCategory("\u53c2\u6570");
                ((AbstractLeftPart)part).setVariableLabel(pc.Identifier().getText());
            }
            RuleParserParser.ExprConditionContext conditionContext = expCollectContext.exprCondition();
            if (conditionContext != null) {
                MultiCondition condition = this.buildMultiCondition(conditionContext);
                ((AbstractLeftPart)part).setMultiCondition(condition);
            }
            if (expCollectContext.property() != null) {
                ((CollectLeftPart)part).setProperty(expCollectContext.property().getText());
                if (expCollectContext.SUM() != null) {
                    ((CollectLeftPart)part).setPurpose(CollectPurpose.sum);
                } else if (expCollectContext.MAX() != null) {
                    ((CollectLeftPart)part).setPurpose(CollectPurpose.max);
                } else if (expCollectContext.MIN() != null) {
                    ((CollectLeftPart)part).setPurpose(CollectPurpose.min);
                } else if (expCollectContext.AVG() != null) {
                    ((CollectLeftPart)part).setPurpose(CollectPurpose.avg);
                }
            } else {
                ((CollectLeftPart)part).setPurpose(CollectPurpose.count);
            }
            left.setType(LeftType.collect);
            leftPart = part;
        }
        left.setLeftPart(leftPart);
        criteria.setLeft(left);
        Op op = DSLUtils.parseOp(ctx.op());
        criteria.setOp(op);
        RuleParserParser.NullValueContext nullValueContext = ctx.nullValue();
        if (nullValueContext != null) {
            if (op.equals((Object)Op.Equals)) {
                criteria.setOp(Op.Null);
                return criteria;
            } else {
                if (!op.equals((Object)Op.NotEquals)) throw new RuleException("'null' value only support '==' or '!=' operator.");
                criteria.setOp(Op.NotNull);
            }
            return criteria;
        } else {
            criteria.setValue(BuildUtils.buildValue(ctx.complexValue()));
        }
        return criteria;
    }

    private MultiCondition buildMultiCondition(RuleParserParser.ExprConditionContext conditionContext) {
        MultiCondition multiCondition = new MultiCondition();
        this.buildPropertyCriteria(conditionContext, multiCondition);
        return multiCondition;
    }

    private void buildPropertyCriteria(RuleParserParser.ExprConditionContext conditionContext, MultiCondition multiCondition) {
        List<RuleParserParser.JoinContext> joins = conditionContext.join();
        if (joins == null || joins.size() == 0) {
            multiCondition.addCondition(this.newPropertyCriteria(conditionContext));
        } else {
            RuleParserParser.JoinContext joinContext = joins.get(0);
            if (joinContext.AND() != null) {
                multiCondition.setType(JunctionType.and);
            } else {
                multiCondition.setType(JunctionType.or);
            }
            List children = conditionContext.children;
            for (ParseTree parseTree : children) {
                if (!(parseTree instanceof RuleParserParser.ExprConditionContext)) continue;
                RuleParserParser.ExprConditionContext ecc = (RuleParserParser.ExprConditionContext)parseTree;
                if (ecc.property() == null) {
                    this.buildPropertyCriteria(ecc, multiCondition);
                    continue;
                }
                multiCondition.addCondition(this.newPropertyCriteria(ecc));
            }
        }
    }

    private PropertyCriteria newPropertyCriteria(RuleParserParser.ExprConditionContext conditionContext) {
        String property = conditionContext.property().getText();
        PropertyCriteria pc = new PropertyCriteria();
        pc.setProperty(property);
        Op op = DSLUtils.parseOp(conditionContext.op());
        pc.setOp(op);
        RuleParserParser.ComplexValueContext complexValueContext = conditionContext.complexValue();
        RuleParserParser.NullValueContext nullValueContext = conditionContext.nullValue();
        if (nullValueContext != null && !op.equals((Object)Op.Equals) && !op.equals((Object)Op.NotEquals)) {
            throw new RuleException("'$null' value only support '==' or '!=' operator.");
        }
        pc.setValue(BuildUtils.buildValue(complexValueContext));
        return pc;
    }

    @Override
    public boolean support(ParserRuleContext context) {
        return context instanceof RuleParserParser.SingleConditionContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.functionDescriptors = applicationContext.getBeansOfType(FunctionDescriptor.class).values();
    }
}

