/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dsl.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.rule.AbstractValue;
import com.bstek.urule.model.rule.ArithmeticType;
import com.bstek.urule.model.rule.CommonFunctionValue;
import com.bstek.urule.model.rule.ComplexArithmetic;
import com.bstek.urule.model.rule.ConstantValue;
import com.bstek.urule.model.rule.MethodValue;
import com.bstek.urule.model.rule.NamedReferenceValue;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.ParameterValue;
import com.bstek.urule.model.rule.ParenValue;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class BuildUtils {
    public static AbstractValue buildValue(RuleParserParser.ComplexValueContext context) {
        AbstractValue value = null;
        if (context.leftParen() != null) {
            ParenValue pv = new ParenValue();
            List<RuleParserParser.ComplexValueContext> values = context.complexValue();
            AbstractValue v = BuildUtils.buildValue(values.get(0));
            pv.setValue(v);
            value = pv;
        } else if (context.value() != null) {
            value = BuildUtils.buildSimpleValue(context.value());
        } else if (context.variable() != null) {
            value = BuildUtils.buildVariableValue(context.variable());
        } else if (context.constant() != null) {
            value = BuildUtils.buildConstantValue(context.constant());
        } else if (context.variableCategory() != null) {
            RuleParserParser.VariableCategoryContext vcc = context.variableCategory();
            String name = vcc.Identifier().getText();
            value = new VariableCategoryValue(name);
        } else if (context.parameter() != null) {
            RuleParserParser.ParameterContext parameterContext = context.parameter();
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.setVariableLabel(parameterContext.Identifier().getText());
            value = parameterValue;
        } else if (context.namedVariable() != null) {
            RuleParserParser.NamedVariableContext namedVariableContext = context.namedVariable();
            String refName = namedVariableContext.namedVariableCategory().getText();
            String property = namedVariableContext.property().getText();
            NamedReferenceValue refValue = new NamedReferenceValue();
            refValue.setReferenceName(refName);
            refValue.setPropertyLabel(property);
            value = refValue;
        } else if (context.methodInvoke() != null) {
            RuleParserParser.MethodInvokeContext actionContext = context.methodInvoke();
            MethodValue mv = new MethodValue();
            RuleParserParser.BeanMethodContext beanMethodContext = actionContext.beanMethod();
            String beanLabel = beanMethodContext.Identifier(0).getText();
            String methodLabel = beanMethodContext.Identifier(1).getText();
            mv.setBeanLabel(beanLabel);
            mv.setMethodLabel(methodLabel);
            RuleParserParser.ActionParametersContext actionParametersContext = actionContext.actionParameters();
            if (actionParametersContext != null && actionParametersContext.complexValue() != null) {
                List<RuleParserParser.ComplexValueContext> values = actionParametersContext.complexValue();
                ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                for (RuleParserParser.ComplexValueContext cvx : values) {
                    Parameter parameter = new Parameter();
                    parameter.setValue(BuildUtils.buildValue(cvx));
                    parameters.add(parameter);
                }
                mv.setParameters(parameters);
            }
            value = mv;
        } else if (context.commonFunction() != null) {
            RuleParserParser.CommonFunctionContext commonFunctionContext = context.commonFunction();
            Collection functionDescriptors = Utils.getApplicationContext().getBeansOfType(FunctionDescriptor.class).values();
            CommonFunctionValue functionValue = new CommonFunctionValue();
            String nameorlabel = commonFunctionContext.Identifier().getText();
            for (FunctionDescriptor fun : functionDescriptors) {
                if (nameorlabel.equals(fun.getName())) {
                    functionValue.setName(fun.getName());
                    functionValue.setLabel(fun.getLabel());
                    break;
                }
                if (!nameorlabel.equals(fun.getLabel())) continue;
                functionValue.setName(fun.getName());
                functionValue.setLabel(fun.getLabel());
                break;
            }
            if (functionValue.getName() == null) {
                throw new RuleException("Function[" + nameorlabel + "] not exist.");
            }
            RuleParserParser.ComplexValueContext complexValue = commonFunctionContext.complexValue();
            CommonFunctionParameter param = new CommonFunctionParameter();
            param.setObjectParameter(BuildUtils.buildValue(complexValue));
            RuleParserParser.PropertyContext propertyContext = commonFunctionContext.property();
            if (propertyContext != null) {
                param.setProperty(propertyContext.getText());
            }
            functionValue.setParameter(param);
            value = functionValue;
        } else if (context.complexValue() != null) {
            List<RuleParserParser.ComplexValueContext> values = context.complexValue();
            value = BuildUtils.buildValue(values.get(0));
        }
        List<TerminalNode> arithList = context.ARITH();
        if (arithList != null && arithList.size() > 0) {
            TerminalNode arithNode = arithList.get(0);
            ComplexArithmetic arith = new ComplexArithmetic();
            arith.setType(ArithmeticType.parse(arithNode.getText()));
            ParseTree nextContext = context.getChild(2);
            arith.setValue(BuildUtils.buildValue((RuleParserParser.ComplexValueContext)nextContext));
            value.setArithmetic(arith);
        }
        return value;
    }

    private static ConstantValue buildConstantValue(RuleParserParser.ConstantContext context) {
        ConstantValue value = new ConstantValue();
        value.setConstantCategory(context.constantCategory().Identifier().getText());
        value.setConstantLabel(context.property().getText());
        return value;
    }

    private static VariableValue buildVariableValue(RuleParserParser.VariableContext context) {
        VariableValue value = new VariableValue();
        value.setVariableCategory(context.variableCategory().getText());
        value.setVariableLabel(context.property().getText());
        return value;
    }

    private static SimpleValue buildSimpleValue(RuleParserParser.ValueContext context) {
        SimpleValue value = new SimpleValue();
        if (context.STRING() != null) {
            value.setContent(BuildUtils.getSTRINGContent(context.STRING()));
        } else if (context.Boolean() != null) {
            value.setContent(context.Boolean().getText());
        } else if (context.NUMBER() != null) {
            value.setContent(context.NUMBER().getText());
        }
        return value;
    }

    public static String getSTRINGContent(TerminalNode node) {
        String text = node.getText();
        return text.substring(1, text.length() - 1);
    }
}

