/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dsl.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.action.Action;
import com.bstek.urule.action.ConsolePrintAction;
import com.bstek.urule.action.ExecuteCommonFunctionAction;
import com.bstek.urule.action.ExecuteMethodAction;
import com.bstek.urule.action.VariableAssignAction;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.dsl.builder.AbstractContextBuilder;
import com.bstek.urule.dsl.builder.BuildUtils;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.rule.AbstractValue;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.model.rule.lhs.LeftType;
import java.util.Collection;
import org.antlr.v4.runtime.ParserRuleContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ActionContextBuilder
extends AbstractContextBuilder
implements ApplicationContextAware {
    private Collection<FunctionDescriptor> functionDescriptors;

    @Override
    public Action build(ParserRuleContext context) {
        RuleParserParser.ActionContext ctx = (RuleParserParser.ActionContext)context;
        if (ctx.outAction() != null) {
            return this.buildConsolePrintAction(ctx.outAction());
        }
        if (ctx.assignAction() != null) {
            return this.buildVariableAssignAction(ctx.assignAction());
        }
        if (ctx.methodInvoke() != null) {
            return this.buildExecuteMethodAction(ctx.methodInvoke());
        }
        if (ctx.commonFunction() != null) {
            return this.buildExecuteCommonFunctionAction(ctx.commonFunction());
        }
        return null;
    }

    private ExecuteCommonFunctionAction buildExecuteCommonFunctionAction(RuleParserParser.CommonFunctionContext context) {
        ExecuteCommonFunctionAction action = new ExecuteCommonFunctionAction();
        String nameorlabel = context.Identifier().getText();
        for (FunctionDescriptor fun : this.functionDescriptors) {
            if (nameorlabel.equals(fun.getName())) {
                action.setName(fun.getName());
                action.setLabel(fun.getLabel());
                break;
            }
            if (!nameorlabel.equals(fun.getLabel())) continue;
            action.setName(fun.getName());
            action.setLabel(fun.getLabel());
            break;
        }
        if (action.getName() == null) {
            throw new RuleException("Function[" + nameorlabel + "] not exist.");
        }
        RuleParserParser.ComplexValueContext value = context.complexValue();
        CommonFunctionParameter param = new CommonFunctionParameter();
        param.setObjectParameter(BuildUtils.buildValue(value));
        RuleParserParser.PropertyContext propertyContext = context.property();
        if (propertyContext != null) {
            param.setProperty(propertyContext.getText());
        }
        action.setParameter(param);
        return action;
    }

    private ExecuteMethodAction buildExecuteMethodAction(RuleParserParser.MethodInvokeContext context) {
        ExecuteMethodAction action = new ExecuteMethodAction();
        RuleParserParser.BeanMethodContext methodContext = context.beanMethod();
        action.setBeanLabel(methodContext.getChild(0).getText());
        action.setMethodLabel(methodContext.getChild(2).getText());
        RuleParserParser.ActionParametersContext parametersContext = context.actionParameters();
        if (parametersContext != null) {
            for (RuleParserParser.ComplexValueContext ctx : parametersContext.complexValue()) {
                Parameter parameter = new Parameter();
                parameter.setValue(BuildUtils.buildValue(ctx));
                action.addParameter(parameter);
            }
        }
        return action;
    }

    private VariableAssignAction buildVariableAssignAction(RuleParserParser.AssignActionContext context) {
        VariableAssignAction action = new VariableAssignAction();
        RuleParserParser.ParameterContext parameterContext = context.parameter();
        RuleParserParser.NamedVariableContext namedVariableContext = context.namedVariable();
        if (namedVariableContext != null) {
            action.setReferenceName(namedVariableContext.namedVariableCategory().getText());
            action.setVariableLabel(namedVariableContext.property().getText());
            action.setType(LeftType.NamedReference);
        } else if (parameterContext == null) {
            action.setVariableCategory(context.variable().variableCategory().getText());
            action.setVariableLabel(context.variable().property().getText());
        } else {
            action.setVariableCategory("\u53c2\u6570");
            action.setVariableLabel(parameterContext.Identifier().getText());
        }
        action.setValue(BuildUtils.buildValue(context.complexValue()));
        return action;
    }

    private ConsolePrintAction buildConsolePrintAction(RuleParserParser.OutActionContext context) {
        ConsolePrintAction action = new ConsolePrintAction();
        AbstractValue value = BuildUtils.buildValue(context.complexValue());
        action.setValue(value);
        return action;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.functionDescriptors = applicationContext.getBeansOfType(FunctionDescriptor.class).values();
    }

    @Override
    public boolean support(ParserRuleContext context) {
        return context instanceof RuleParserParser.ActionContext;
    }
}

