/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dsl;

import com.bstek.urule.RuleException;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.dsl.BuildRulesVisitor;
import com.bstek.urule.dsl.RuleParserLexer;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.dsl.ScriptDecisionTableErrorListener;
import com.bstek.urule.dsl.builder.ContextBuilder;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DSLRuleSetBuilder
implements ApplicationContextAware {
    public static final String BEAN_ID = "urule.dslRuleSetBuilder";
    private Collection<ContextBuilder> contextBuilders;
    private RulesRebuilder rulesRebuilder;

    public RuleSet build(String script) throws IOException {
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(script);
        RuleParserLexer lexer = new RuleParserLexer((CharStream)antlrInputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        RuleParserParser parser = new RuleParserParser((TokenStream)tokenStream);
        ScriptDecisionTableErrorListener errorListener = new ScriptDecisionTableErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        BuildRulesVisitor visitor = new BuildRulesVisitor(this.contextBuilders, tokenStream);
        RuleSet ruleSet = visitor.visitRuleSet(parser.ruleSet());
        this.rebuildRuleSet(ruleSet);
        String error = errorListener.getErrorMessage();
        if (error != null) {
            throw new RuleException("Script parse error:" + error);
        }
        return ruleSet;
    }

    private void rebuildRuleSet(RuleSet ruleSet) {
        List<Library> libraries = ruleSet.getLibraries();
        List<Rule> rules = ruleSet.getRules();
        this.rulesRebuilder.rebuildRulesForDSL(libraries, rules);
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.rulesRebuilder = rulesRebuilder;
    }

    public boolean support(Resource resource) {
        String path = resource.getPath();
        return path.toLowerCase().endsWith(".ul");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.contextBuilders = applicationContext.getBeansOfType(ContextBuilder.class).values();
    }
}

