/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dsl;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.action.Action;
import com.bstek.urule.dsl.RuleParserBaseVisitor;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.dsl.builder.BuildUtils;
import com.bstek.urule.dsl.builder.ContextBuilder;
import com.bstek.urule.dsl.builder.NamedConditionBuilder;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Other;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.CriteriaUnit;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.model.rule.lhs.NamedCriteria;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.rule.loop.LoopEnd;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.rule.loop.LoopStart;
import com.bstek.urule.model.rule.loop.LoopTarget;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class BuildRulesVisitor
extends RuleParserBaseVisitor<Object> {
    private Map<ParseTree, Junction> map = new HashMap<ParseTree, Junction>();
    private Collection<ContextBuilder> builders;
    private NamedConditionBuilder namedConditionBuilder = new NamedConditionBuilder();
    private CommonTokenStream tokenStream;

    public BuildRulesVisitor(Collection<ContextBuilder> builders, CommonTokenStream tokenStream) {
        this.builders = builders;
        this.tokenStream = tokenStream;
    }

    @Override
    public RuleSet visitRuleSet(RuleParserParser.RuleSetContext ctx) {
        RuleParserParser.RuleSetBodyContext ruleSetBodyContext;
        List<RuleParserParser.RulesContext> rulesContextList;
        RuleSet ruleSet = new RuleSet();
        RuleParserParser.RuleSetHeaderContext ruleSetHeaderContext = ctx.ruleSetHeader();
        List<RuleParserParser.ResourceContext> resourcesContext = ruleSetHeaderContext.resource();
        if (resourcesContext != null) {
            for (RuleParserParser.ResourceContext context : resourcesContext) {
                ruleSet.addLibrary(this.visitResource(context));
            }
        }
        StringBuffer sb = null;
        List<RuleParserParser.FunctionImportContext> functionImportContextList = ruleSetHeaderContext.functionImport();
        if (functionImportContextList != null) {
            sb = new StringBuffer();
            for (RuleParserParser.FunctionImportContext importContext : functionImportContextList) {
                sb.append("import ");
                sb.append(importContext.packageDef().getText());
                sb.append(";");
            }
        }
        if ((rulesContextList = (ruleSetBodyContext = ctx.ruleSetBody()).rules()) != null) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            ruleSet.setRules(rules);
            for (RuleParserParser.RulesContext ruleContext : rulesContextList) {
                RuleParserParser.LoopRuleDefContext loopRuleDefContext;
                RuleParserParser.RuleDefContext ruleDefContext = ruleContext.ruleDef();
                if (ruleDefContext != null) {
                    Rule rule = this.visitRuleDef(ruleDefContext);
                    rules.add(rule);
                }
                if ((loopRuleDefContext = ruleContext.loopRuleDef()) == null) continue;
                LoopRule rule = this.visitLoopRuleDef(loopRuleDefContext);
                rules.add(rule);
            }
        }
        return ruleSet;
    }

    private String buildFunctionBody(RuleParserParser.ExpressionBodyContext expressionBodyContext) {
        StringBuffer sb = new StringBuffer();
        for (ParseTree node : expressionBodyContext.children) {
            Interval interval = node.getSourceInterval();
            int index = interval.a;
            List leftTokens = this.tokenStream.getHiddenTokensToLeft(index);
            if (leftTokens != null) {
                Token token = (Token)leftTokens.get(0);
                String text = token.getText();
                sb.append(text);
            }
            sb.append(node.getText());
            List rightTokens = this.tokenStream.getHiddenTokensToRight(index);
            if (rightTokens == null) continue;
            Token token = (Token)rightTokens.get(0);
            String text = token.getText();
            sb.append(text);
        }
        return sb.toString();
    }

    @Override
    public Library visitResource(RuleParserParser.ResourceContext ctx) {
        return (Library)this.doBuilder(ctx);
    }

    @Override
    public LoopRule visitLoopRuleDef(RuleParserParser.LoopRuleDefContext ctx) {
        List<RuleParserParser.AttributeContext> attributesContext;
        List<RuleParserParser.ActionContext> actionContextList;
        RuleParserParser.LoopEndContext endContext;
        List<RuleParserParser.ActionContext> actionContextList2;
        SimpleDateFormat sd = new SimpleDateFormat(Configure.getDateFormat());
        LoopRule rule = new LoopRule();
        String name = ctx.STRING().getText();
        name = name.substring(1, name.length() - 1);
        rule.setName(name);
        RuleParserParser.LoopTargetContext target = ctx.loopTarget();
        RuleParserParser.ComplexValueContext valueContext = target.complexValue();
        LoopTarget loopTarget = new LoopTarget();
        loopTarget.setValue(BuildUtils.buildValue(valueContext));
        rule.setLoopTarget(loopTarget);
        RuleParserParser.LoopStartContext startContext = ctx.loopStart();
        if (startContext != null && (actionContextList2 = startContext.action()) != null) {
            LoopStart loopStart = new LoopStart();
            loopStart.setActions(this.buildActions(actionContextList2));
            rule.setLoopStart(loopStart);
        }
        if ((endContext = ctx.loopEnd()) != null && (actionContextList = endContext.action()) != null) {
            LoopEnd loopEnd = new LoopEnd();
            loopEnd.setActions(this.buildActions(actionContextList));
            rule.setLoopEnd(loopEnd);
        }
        if ((attributesContext = ctx.attribute()) != null) {
            for (RuleParserParser.AttributeContext context : attributesContext) {
                String value;
                String dateValue;
                if (context.salienceAttribute() != null) {
                    rule.setSalience(Integer.valueOf(context.salienceAttribute().NUMBER().getText()));
                    continue;
                }
                if (context.loopAttribute() != null) {
                    rule.setLoop(Boolean.valueOf(context.loopAttribute().Boolean().getText()));
                    continue;
                }
                if (context.effectiveDateAttribute() != null) {
                    try {
                        dateValue = context.effectiveDateAttribute().STRING().getText();
                        dateValue = dateValue.substring(1, dateValue.length() - 1);
                        rule.setEffectiveDate(sd.parse(dateValue));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new RuleException(e);
                    }
                }
                if (context.expiresDateAttribute() != null) {
                    try {
                        dateValue = context.expiresDateAttribute().STRING().getText();
                        dateValue = dateValue.substring(1, dateValue.length() - 1);
                        rule.setExpiresDate(sd.parse(dateValue));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new RuleException(e);
                    }
                }
                if (context.enabledAttribute() != null) {
                    rule.setEnabled(Boolean.valueOf(context.enabledAttribute().Boolean().getText()));
                    continue;
                }
                if (context.debugAttribute() != null) {
                    rule.setDebug(Boolean.valueOf(context.debugAttribute().Boolean().getText()));
                    continue;
                }
                if (context.activationGroupAttribute() != null) {
                    value = context.activationGroupAttribute().STRING().getText();
                    value = value.substring(1, value.length() - 1);
                    rule.setActivationGroup(value);
                    continue;
                }
                if (context.agendaGroupAttribute() != null) {
                    value = context.agendaGroupAttribute().STRING().getText();
                    value = value.substring(1, value.length() - 1);
                    rule.setAgendaGroup(value);
                    continue;
                }
                if (context.autoFocusAttribute() != null) {
                    rule.setAutoFocus(Boolean.valueOf(context.autoFocusAttribute().Boolean().getText()));
                    continue;
                }
                if (context.ruleflowGroupAttribute() == null) continue;
                value = context.ruleflowGroupAttribute().STRING().getText();
                value = value.substring(1, value.length() - 1);
                rule.setRuleflowGroup(value);
            }
        }
        RuleParserParser.LeftContext leftContext = ctx.left();
        ParseTree parseTree = leftContext.getChild(1);
        Lhs lhs = new Lhs();
        rule.setLhs(lhs);
        Criterion criterion = this.buildCriterion(parseTree);
        lhs.setCriterion(criterion);
        Rhs rhs = new Rhs();
        rhs.setActions((List<Action>)this.visitRight(ctx.right()));
        rule.setRhs(rhs);
        Other other = new Other();
        other.setActions((List<Action>)this.visitOther(ctx.other()));
        rule.setOther(other);
        return rule;
    }

    @Override
    public Rule visitRuleDef(RuleParserParser.RuleDefContext ctx) {
        SimpleDateFormat sd = new SimpleDateFormat(Configure.getDateFormat());
        Rule rule = new Rule();
        String name = ctx.STRING().getText();
        name = name.substring(1, name.length() - 1);
        rule.setName(name);
        List<RuleParserParser.AttributeContext> attributesContext = ctx.attribute();
        if (attributesContext != null) {
            for (RuleParserParser.AttributeContext context : attributesContext) {
                String value;
                String dateValue;
                if (context.salienceAttribute() != null) {
                    rule.setSalience(Integer.valueOf(context.salienceAttribute().NUMBER().getText()));
                    continue;
                }
                if (context.loopAttribute() != null) {
                    rule.setLoop(Boolean.valueOf(context.loopAttribute().Boolean().getText()));
                    continue;
                }
                if (context.effectiveDateAttribute() != null) {
                    try {
                        dateValue = context.effectiveDateAttribute().STRING().getText();
                        dateValue = dateValue.substring(1, dateValue.length() - 1);
                        rule.setEffectiveDate(sd.parse(dateValue));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new RuleException(e);
                    }
                }
                if (context.expiresDateAttribute() != null) {
                    try {
                        dateValue = context.expiresDateAttribute().STRING().getText();
                        dateValue = dateValue.substring(1, dateValue.length() - 1);
                        rule.setExpiresDate(sd.parse(dateValue));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new RuleException(e);
                    }
                }
                if (context.enabledAttribute() != null) {
                    rule.setEnabled(Boolean.valueOf(context.enabledAttribute().Boolean().getText()));
                    continue;
                }
                if (context.debugAttribute() != null) {
                    rule.setDebug(Boolean.valueOf(context.debugAttribute().Boolean().getText()));
                    continue;
                }
                if (context.activationGroupAttribute() != null) {
                    value = context.activationGroupAttribute().STRING().getText();
                    value = value.substring(1, value.length() - 1);
                    rule.setActivationGroup(value);
                    continue;
                }
                if (context.agendaGroupAttribute() != null) {
                    value = context.agendaGroupAttribute().STRING().getText();
                    value = value.substring(1, value.length() - 1);
                    rule.setAgendaGroup(value);
                    continue;
                }
                if (context.autoFocusAttribute() != null) {
                    rule.setAutoFocus(Boolean.valueOf(context.autoFocusAttribute().Boolean().getText()));
                    continue;
                }
                if (context.ruleflowGroupAttribute() == null) continue;
                value = context.ruleflowGroupAttribute().STRING().getText();
                value = value.substring(1, value.length() - 1);
                rule.setRuleflowGroup(value);
            }
        }
        RuleParserParser.LeftContext leftContext = ctx.left();
        ParseTree parseTree = leftContext.getChild(1);
        Lhs lhs = new Lhs();
        rule.setLhs(lhs);
        Criterion criterion = this.buildCriterion(parseTree);
        lhs.setCriterion(criterion);
        Rhs rhs = new Rhs();
        rhs.setActions((List<Action>)this.visitRight(ctx.right()));
        rule.setRhs(rhs);
        Other other = new Other();
        other.setActions((List<Action>)this.visitOther(ctx.other()));
        rule.setOther(other);
        return rule;
    }

    @Override
    public Criteria visitSingleCondition(RuleParserParser.SingleConditionContext ctx) {
        return (Criteria)this.doBuilder(ctx);
    }

    @Override
    public Criterion visitParenConditions(RuleParserParser.ParenConditionsContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        return this.buildCriterion(parseTree);
    }

    @Override
    public Criterion visitSingleNamedConditionSet(RuleParserParser.SingleNamedConditionSetContext ctx) {
        NamedCriteria criteria = new NamedCriteria();
        RuleParserParser.NamedConditionSetContext conditionSet = ctx.namedConditionSet();
        if (conditionSet.refName() != null) {
            criteria.setReferenceName(conditionSet.refName().getText());
        }
        criteria.setVariableCategory(conditionSet.refObject().getText());
        RuleParserParser.NamedConditionContext namedConditionContext = conditionSet.namedCondition();
        CriteriaUnit unit = this.namedConditionBuilder.buildNamedCriteria(namedConditionContext, criteria.getVariableCategory());
        criteria.setUnit(unit);
        return criteria;
    }

    @Override
    public Criterion visitMultiConditions(RuleParserParser.MultiConditionsContext ctx) {
        Junction topJunction = null;
        Criterion criterion = null;
        Junction junction = this.map.get((Object)ctx);
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (parseTree instanceof RuleParserParser.JoinContext) {
                RuleParserParser.JoinContext joinContext = (RuleParserParser.JoinContext)parseTree;
                if (joinContext.AND() != null) {
                    if (junction == null) {
                        topJunction = junction = new And();
                        junction.addCriterion(criterion);
                        continue;
                    }
                    if (junction instanceof And) continue;
                    And newAnd = new And();
                    junction.addCriterion(newAnd);
                    junction = newAnd;
                    continue;
                }
                if (junction == null) {
                    topJunction = junction = new Or();
                    junction.addCriterion(criterion);
                    continue;
                }
                if (junction instanceof Or) continue;
                Or newOr = new Or();
                junction.addCriterion(newOr);
                junction = newOr;
                continue;
            }
            boolean isMulti = false;
            if (parseTree instanceof RuleParserParser.MultiConditionsContext) {
                isMulti = true;
            }
            if (junction != null && isMulti) {
                this.map.put(parseTree, junction);
            }
            criterion = this.buildCriterion(parseTree);
            if (junction == null || isMulti) continue;
            junction.addCriterion(criterion);
        }
        if (topJunction != null) {
            return topJunction;
        }
        return criterion;
    }

    @Override
    public List<Action> visitRight(RuleParserParser.RightContext ctx) {
        if (ctx == null || ctx.action() == null) {
            return null;
        }
        List<RuleParserParser.ActionContext> actionContexts = ctx.action();
        return this.buildActions(actionContexts);
    }

    private List<Action> buildActions(List<RuleParserParser.ActionContext> actionContexts) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (RuleParserParser.ActionContext actionContext : actionContexts) {
            Action action = (Action)this.doBuilder(actionContext);
            actions.add(action);
        }
        return actions;
    }

    @Override
    public List<Action> visitOther(RuleParserParser.OtherContext ctx) {
        if (ctx == null || ctx.action() == null) {
            return null;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (RuleParserParser.ActionContext actionContext : ctx.action()) {
            Action action = (Action)this.doBuilder(actionContext);
            actions.add(action);
        }
        return actions;
    }

    private Criterion buildCriterion(ParseTree parseTree) {
        Criterion criterion = null;
        if (parseTree instanceof RuleParserParser.ParenConditionsContext) {
            criterion = this.visitParenConditions((RuleParserParser.ParenConditionsContext)parseTree);
        } else if (parseTree instanceof RuleParserParser.SingleConditionContext) {
            criterion = this.visitSingleCondition((RuleParserParser.SingleConditionContext)parseTree);
        } else if (parseTree instanceof RuleParserParser.MultiConditionsContext) {
            criterion = this.visitMultiConditions((RuleParserParser.MultiConditionsContext)parseTree);
        } else if (parseTree instanceof RuleParserParser.SingleNamedConditionSetContext) {
            criterion = this.visitSingleNamedConditionSet((RuleParserParser.SingleNamedConditionSetContext)parseTree);
        }
        return criterion;
    }

    private Object doBuilder(ParserRuleContext context) {
        for (ContextBuilder builder : this.builders) {
            if (!builder.support(context)) continue;
            return builder.build(context);
        }
        return null;
    }
}

