/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.debug;

import com.bstek.urule.debug.DebugWriter;
import com.bstek.urule.debug.MessageItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultHtmlFileDebugWriter
implements DebugWriter {
    private String path;

    @Override
    public void write(List<MessageItem> items) throws IOException {
        if (StringUtils.isBlank((String)this.path)) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        for (MessageItem item : items) {
            msg.append(item.toHtml());
        }
        String fullPath = this.path + "/urule-debug.html";
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><title>URule\u8c03\u8bd5\u65e5\u5fd7\u4fe1\u606f</title><body style='font-size:12px'>");
        sb.append(msg.toString());
        sb.append("</body></html>");
        FileOutputStream out = new FileOutputStream(new File(fullPath));
        IOUtils.write((String)sb.toString(), (OutputStream)out);
        out.flush();
        out.close();
    }

    public void setPath(String path) {
        this.path = path;
    }
}

