/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder.table;

import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.model.table.Column;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.Joint;
import com.bstek.urule.model.table.JointType;
import java.util.List;

public class CellContentBuilder {
    public Criterion buildCriterion(Cell cell, Column col) {
        Joint joint = cell.getJoint();
        if (joint == null) {
            return null;
        }
        List<Condition> conditions = joint.getConditions();
        List<Joint> joints = joint.getJoints();
        if (!(conditions != null && conditions.size() != 0 || joints != null && joints.size() != 0)) {
            return null;
        }
        Junction topJunction = null;
        if (conditions.size() == 1) {
            return this.newCriteria(col, conditions.get(0));
        }
        topJunction = joint.getType().equals((Object)JointType.and) ? new And() : new Or();
        this.buildConditionsCriterion(conditions, topJunction, col);
        this.buildJointsCriterion(joints, col, topJunction);
        return topJunction;
    }

    private void buildJointsCriterion(List<Joint> joints, Column col, Junction parentJunction) {
        if (joints == null || joints.size() == 0) {
            return;
        }
        for (Joint joint : joints) {
            Junction junction = joint.getJunction();
            List<Condition> conditions = joint.getConditions();
            this.buildConditionsCriterion(conditions, junction, col);
            List<Joint> children = joint.getJoints();
            this.buildJointsCriterion(children, col, junction);
            parentJunction.addCriterion(junction);
        }
    }

    private void buildConditionsCriterion(List<Condition> conditions, Junction junction, Column col) {
        if (conditions == null || conditions.size() == 0) {
            return;
        }
        for (Condition condition : conditions) {
            Criteria criteria = this.newCriteria(col, condition);
            junction.addCriterion(criteria);
        }
    }

    private Criteria newCriteria(Column col, Condition condition) {
        Criteria criteria = new Criteria();
        Left left = new Left();
        VariableLeftPart part = new VariableLeftPart();
        part.setVariableCategory(col.getVariableCategory());
        part.setVariableName(col.getVariableName());
        part.setVariableLabel(col.getVariableLabel());
        part.setDatatype(col.getDatatype());
        left.setLeftPart(part);
        left.setType(LeftType.variable);
        criteria.setLeft(left);
        criteria.setOp(condition.getOp());
        criteria.setValue(condition.getValue());
        return criteria;
    }
}

