/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder.resource;

import com.bstek.urule.RuleException;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.builder.resource.ResourceProvider;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FileResourceProvider
implements ResourceProvider,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public Resource provide(String path, String version) {
        try {
            InputStream inputStream = this.applicationContext.getResource(path).getInputStream();
            String content = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            IOUtils.closeQuietly((InputStream)inputStream);
            return new Resource(content, path);
        }
        catch (IOException e) {
            throw new RuleException(e);
        }
    }

    @Override
    public boolean support(String path) {
        return path.startsWith("classpath:") || path.startsWith("file:") || path.startsWith("WEB-INF/");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

