/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.builder.AbstractBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.builder.resource.ResourceBuilder;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.action.ActionLibrary;
import com.bstek.urule.model.library.action.SpringBean;
import com.bstek.urule.model.library.constant.ConstantLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.library.variable.VariableLibrary;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.runtime.BuiltInActionLibraryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class ResourceLibraryBuilder
extends AbstractBuilder {
    private BuiltInActionLibraryBuilder builtInActionLibraryBuilder;

    public ResourceLibrary buildResourceLibrary(Collection<Library> libraries) {
        List<SpringBean> builtInActions;
        if (libraries == null) {
            libraries = Collections.EMPTY_LIST;
        }
        ArrayList<ConstantLibrary> constantLibraryLibs = new ArrayList<ConstantLibrary>();
        ArrayList<ActionLibrary> actionLibraryLibs = new ArrayList<ActionLibrary>();
        ArrayList<VariableLibrary> variableCategoryLibs = new ArrayList<VariableLibrary>();
        ArrayList<VariableCategory> parameterVariableCategories = new ArrayList<VariableCategory>();
        ResourceBase resourceBase = this.newResourceBase();
        for (Library library : libraries) {
            resourceBase.addResource(library.getPath(), library.getVersion());
        }
        block1: for (Resource resource : resourceBase.getResources()) {
            String content = resource.getContent();
            Element root = this.parseResource(content);
            for (ResourceBuilder builder : this.resourceBuilders) {
                if (!builder.support(root)) continue;
                Object object = builder.build(root);
                ResourceType type = builder.getType();
                if (type.equals((Object)ResourceType.ActionLibrary)) {
                    ActionLibrary al = (ActionLibrary)object;
                    actionLibraryLibs.add(al);
                    continue block1;
                }
                if (type.equals((Object)ResourceType.VariableLibrary)) {
                    VariableLibrary vl = (VariableLibrary)object;
                    variableCategoryLibs.add(vl);
                    continue block1;
                }
                if (type.equals((Object)ResourceType.ConstantLibrary)) {
                    ConstantLibrary cl = (ConstantLibrary)object;
                    constantLibraryLibs.add(cl);
                    continue block1;
                }
                if (!type.equals((Object)ResourceType.ParameterLibrary)) continue block1;
                VariableCategory category = (VariableCategory)object;
                parameterVariableCategories.add(category);
                continue block1;
            }
        }
        if (parameterVariableCategories.size() > 0) {
            VariableCategory category = (VariableCategory)parameterVariableCategories.get(0);
            for (VariableCategory vc : parameterVariableCategories) {
                if (vc.equals(category) || vc.getVariables() == null) continue;
                for (Variable v : vc.getVariables()) {
                    category.addVariable(v);
                }
            }
            VariableLibrary variableLibrary = new VariableLibrary();
            variableLibrary.addVariableCategory(category);
            variableCategoryLibs.add(variableLibrary);
        }
        if ((builtInActions = this.builtInActionLibraryBuilder.getBuiltInActions()).size() > 0) {
            ActionLibrary actionLibrary = new ActionLibrary();
            actionLibrary.setSpringBeans(builtInActions);
            actionLibraryLibs.add(actionLibrary);
        }
        return new ResourceLibrary(variableCategoryLibs, actionLibraryLibs, constantLibraryLibs);
    }

    public void setBuiltInActionLibraryBuilder(BuiltInActionLibraryBuilder builtInActionLibraryBuilder) {
        this.builtInActionLibraryBuilder = builtInActionLibraryBuilder;
    }
}

