/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.builder.resource.ResourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceBase {
    private Collection<ResourceProvider> providers;
    private List<Resource> resources = new ArrayList<Resource>();

    protected ResourceBase(Collection<ResourceProvider> providers) {
        this.providers = providers;
    }

    public ResourceBase addResource(String path, String version) {
        boolean support = false;
        for (ResourceProvider provider : this.providers) {
            if (!provider.support(path)) continue;
            support = true;
            this.resources.add(provider.provide(path, version));
            break;
        }
        if (!support) {
            throw new RuleException("Unsupport rule file source : " + path);
        }
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }
}

