/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.builder.AbstractBuilder;
import com.bstek.urule.builder.DecisionTreeRulesBuilder;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.builder.ResourceLibraryBuilder;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.builder.resource.Resource;
import com.bstek.urule.builder.resource.ResourceBuilder;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.builder.table.DecisionTableRulesBuilder;
import com.bstek.urule.builder.table.ScriptDecisionTableRulesBuilder;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.model.decisiontree.DecisionTree;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.builder.ReteBuilder;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.scorecard.runtime.ScoreRule;
import com.bstek.urule.model.table.DecisionTable;
import com.bstek.urule.model.table.ScriptDecisionTable;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.service.KnowledgePackageService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class KnowledgeBuilder
extends AbstractBuilder {
    private ResourceLibraryBuilder resourceLibraryBuilder;
    private ReteBuilder reteBuilder;
    private RulesRebuilder rulesRebuilder;
    private DecisionTreeRulesBuilder decisionTreeRulesBuilder;
    private DecisionTableRulesBuilder decisionTableRulesBuilder;
    private ScriptDecisionTableRulesBuilder scriptDecisionTableRulesBuilder;
    private DSLRuleSetBuilder dslRuleSetBuilder;
    public static final String BEAN_ID = "urule.knowledgeBuilder";

    public KnowledgeBase buildKnowledgeBase(ResourceBase resourceBase) throws IOException {
        KnowledgePackageService knowledgePackageService = (KnowledgePackageService)this.applicationContext.getBean("urule.knowledgePackageService");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashMap<String, Library> libMap = new HashMap<String, Library>();
        HashMap<String, FlowDefinition> flowMap = new HashMap<String, FlowDefinition>();
        block0: for (Resource resource : resourceBase.getResources()) {
            if (this.dslRuleSetBuilder.support(resource)) {
                RuleSet ruleSet = this.dslRuleSetBuilder.build(resource.getContent());
                this.addToLibraryMap(libMap, ruleSet.getLibraries());
                if (ruleSet.getRules() == null) continue;
                rules.addAll(ruleSet.getRules());
                continue;
            }
            Element root = this.parseResource(resource.getContent());
            for (ResourceBuilder builder : this.resourceBuilders) {
                Object table;
                RuleSet ruleSet;
                if (!builder.support(root)) continue;
                Object object = builder.build(root);
                ResourceType type = builder.getType();
                if (type.equals((Object)ResourceType.RuleSet)) {
                    RuleSet ruleSet2 = (RuleSet)object;
                    this.addToLibraryMap(libMap, ruleSet2.getLibraries());
                    if (ruleSet2.getRules() == null) continue block0;
                    List<Rule> ruleList = ruleSet2.getRules();
                    this.rulesRebuilder.convertNamedJunctions(ruleList);
                    for (Rule rule : ruleList) {
                        if (rule.getEnabled() != null && !rule.getEnabled().booleanValue()) continue;
                        rules.add(rule);
                    }
                    continue block0;
                }
                if (type.equals((Object)ResourceType.DecisionTree)) {
                    DecisionTree tree = (DecisionTree)object;
                    this.addToLibraryMap(libMap, tree.getLibraries());
                    ruleSet = this.decisionTreeRulesBuilder.buildRules(tree);
                    this.addToLibraryMap(libMap, ruleSet.getLibraries());
                    if (ruleSet.getRules() == null) continue block0;
                    rules.addAll(ruleSet.getRules());
                    continue block0;
                }
                if (type.equals((Object)ResourceType.DecisionTable)) {
                    table = (DecisionTable)object;
                    this.addToLibraryMap(libMap, ((DecisionTable)table).getLibraries());
                    List<Rule> tableRules = this.decisionTableRulesBuilder.buildRules((DecisionTable)table);
                    rules.addAll(tableRules);
                    continue block0;
                }
                if (type.equals((Object)ResourceType.ScriptDecisionTable)) {
                    table = (ScriptDecisionTable)object;
                    ruleSet = this.scriptDecisionTableRulesBuilder.buildRules((ScriptDecisionTable)table);
                    this.addToLibraryMap(libMap, ruleSet.getLibraries());
                    if (ruleSet.getRules() == null) continue block0;
                    rules.addAll(ruleSet.getRules());
                    continue block0;
                }
                if (type.equals((Object)ResourceType.Flow)) {
                    FlowDefinition fd = (FlowDefinition)object;
                    fd.initNodeKnowledgePackage(this, knowledgePackageService, this.dslRuleSetBuilder);
                    this.addToLibraryMap(libMap, fd.getLibraries());
                    flowMap.put(fd.getId(), fd);
                    continue block0;
                }
                if (!type.equals((Object)ResourceType.Scorecard)) continue block0;
                ScoreRule rule = (ScoreRule)object;
                rules.add(rule);
                this.addToLibraryMap(libMap, rule.getLibraries());
                continue block0;
            }
        }
        ResourceLibrary resourceLibrary = this.resourceLibraryBuilder.buildResourceLibrary(libMap.values());
        this.buildLoopRules(rules, resourceLibrary);
        Rete rete = this.reteBuilder.buildRete(rules, resourceLibrary);
        return new KnowledgeBase(rete, flowMap, this.retriveNoLhsRules(rules));
    }

    private void buildLoopRules(List<Rule> rules, ResourceLibrary resourceLibrary) {
        for (Rule rule : rules) {
            if (!(rule instanceof LoopRule)) continue;
            LoopRule loopRule = (LoopRule)rule;
            List<Rule> ruleList = this.buildRules(loopRule);
            Rete rete = this.reteBuilder.buildRete(ruleList, resourceLibrary);
            KnowledgeBase base = new KnowledgeBase(rete);
            KnowledgePackageWrapper knowledgeWrapper = new KnowledgePackageWrapper(base.getKnowledgePackage());
            loopRule.setKnowledgePackageWrapper(knowledgeWrapper);
        }
    }

    private List<Rule> buildRules(LoopRule loopRule) {
        Rule rule = new Rule();
        rule.setDebug(loopRule.getDebug());
        rule.setName("loop-rule");
        rule.setLhs(loopRule.getLhs());
        rule.setRhs(loopRule.getRhs());
        rule.setOther(loopRule.getOther());
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(rule);
        return rules;
    }

    public KnowledgeBase buildKnowledgeBase(RuleSet ruleSet) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashMap<String, Library> libMap = new HashMap<String, Library>();
        this.addToLibraryMap(libMap, ruleSet.getLibraries());
        if (ruleSet.getRules() != null) {
            rules.addAll(ruleSet.getRules());
        }
        ResourceLibrary resourceLibrary = this.resourceLibraryBuilder.buildResourceLibrary(libMap.values());
        Rete rete = this.reteBuilder.buildRete(rules, resourceLibrary);
        return new KnowledgeBase(rete, null, this.retriveNoLhsRules(rules));
    }

    private List<Rule> retriveNoLhsRules(List<Rule> rules) {
        ArrayList<Rule> noLhsRules = new ArrayList<Rule>();
        for (Rule rule : rules) {
            Lhs lhs = rule.getLhs();
            if (!(rule instanceof LoopRule) && lhs != null && lhs.getCriterion() != null) continue;
            noLhsRules.add(rule);
        }
        return noLhsRules;
    }

    private void addToLibraryMap(Map<String, Library> map, List<Library> libraries) {
        if (libraries == null) {
            return;
        }
        for (Library lib : libraries) {
            String path = lib.getPath();
            if (map.containsKey(path)) continue;
            map.put(path, lib);
        }
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.rulesRebuilder = rulesRebuilder;
    }

    public void setReteBuilder(ReteBuilder reteBuilder) {
        this.reteBuilder = reteBuilder;
    }

    public void setDecisionTableRulesBuilder(DecisionTableRulesBuilder decisionTableRulesBuilder) {
        this.decisionTableRulesBuilder = decisionTableRulesBuilder;
    }

    public void setScriptDecisionTableRulesBuilder(ScriptDecisionTableRulesBuilder scriptDecisionTableRulesBuilder) {
        this.scriptDecisionTableRulesBuilder = scriptDecisionTableRulesBuilder;
    }

    public void setDslRuleSetBuilder(DSLRuleSetBuilder dslRuleSetBuilder) {
        this.dslRuleSetBuilder = dslRuleSetBuilder;
    }

    public void setResourceLibraryBuilder(ResourceLibraryBuilder resourceLibraryBuilder) {
        this.resourceLibraryBuilder = resourceLibraryBuilder;
    }

    public void setDecisionTreeRulesBuilder(DecisionTreeRulesBuilder decisionTreeRulesBuilder) {
        this.decisionTreeRulesBuilder = decisionTreeRulesBuilder;
    }
}

