/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KnowledgeBase {
    private ResourceLibrary resourceLibrary;
    private Map<String, FlowDefinition> flowMap;
    private Rete rete;
    private KnowledgePackageImpl knowledgePackage;
    private List<Rule> noLhsRules;

    public KnowledgeBase(Rete rete) {
        this(rete, null, null);
    }

    protected KnowledgeBase(Rete rete, Map<String, FlowDefinition> flowMap, List<Rule> noLhsRules) {
        this.rete = rete;
        this.resourceLibrary = rete.getResourceLibrary();
        this.flowMap = flowMap;
        this.noLhsRules = noLhsRules;
    }

    public KnowledgePackage getKnowledgePackage() {
        if (this.knowledgePackage != null) {
            return this.knowledgePackage;
        }
        this.knowledgePackage = new KnowledgePackageImpl();
        this.knowledgePackage.setRete(this.rete);
        this.knowledgePackage.setNoLhsRules(this.noLhsRules);
        this.knowledgePackage.setFlowMap(this.flowMap);
        this.knowledgePackage.buildWithElseRules();
        HashMap<String, String> variableCategoryMap = new HashMap<String, String>();
        this.knowledgePackage.setVariableCategoryMap(variableCategoryMap);
        List<VariableCategory> variableCategories = this.resourceLibrary.getVariableCategories();
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.knowledgePackage.setParameters(parameters);
        for (VariableCategory category : variableCategories) {
            List<Variable> variables;
            String name = category.getName();
            variableCategoryMap.put(name, category.getClazz());
            if (!name.equals("\u53c2\u6570") || (variables = category.getVariables()) == null || variables.size() == 0) continue;
            for (Variable var : variables) {
                parameters.put(var.getName(), var.getType().name());
            }
        }
        return this.knowledgePackage;
    }

    public List<Rule> getNoLhsRules() {
        return this.noLhsRules;
    }

    public Rete getRete() {
        return this.rete;
    }

    public ResourceLibrary getResourceLibrary() {
        return this.resourceLibrary;
    }

    public Map<String, FlowDefinition> getFlowMap() {
        return this.flowMap;
    }
}

