/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.decisiontree.ActionTreeNode;
import com.bstek.urule.model.decisiontree.ConditionTreeNode;
import com.bstek.urule.model.decisiontree.DecisionTree;
import com.bstek.urule.model.decisiontree.TreeNode;
import com.bstek.urule.model.decisiontree.VariableTreeNode;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Lhs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DecisionTreeRulesBuilder {
    public RuleSet buildRules(DecisionTree tree) throws IOException {
        RuleSet rs = new RuleSet();
        List<Library> libs = tree.getLibraries();
        if (libs != null) {
            for (Library lib : libs) {
                rs.addLibrary(lib);
            }
        }
        ArrayList<VariableTreeNode> nodes = new ArrayList<VariableTreeNode>();
        nodes.add(tree.getVariableTreeNode());
        ArrayList<ActionTreeNode> list = new ArrayList<ActionTreeNode>();
        this.fetchActionTreeNodes(nodes, list);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (ActionTreeNode actionNode : list) {
            Rule rule = new Rule();
            rule.setDebug(tree.getDebug());
            rule.setEnabled(tree.getEnabled());
            rule.setEffectiveDate(tree.getEffectiveDate());
            rule.setExpiresDate(tree.getExpiresDate());
            rule.setSalience(tree.getSalience());
            rules.add(rule);
            rule.setName("tree-rule");
            Rhs rhs = new Rhs();
            rhs.setActions(actionNode.getActions());
            rule.setRhs(rhs);
            Lhs lhs = new Lhs();
            rule.setLhs(lhs);
            And and = new And();
            lhs.setCriterion(and);
            ConditionTreeNode treeNode = (ConditionTreeNode)actionNode.getParentNode();
            this.buildCriterion(and, treeNode);
        }
        rs.setRules(rules);
        return rs;
    }

    private void buildCriterion(And and, ConditionTreeNode node) {
        if (node == null) {
            return;
        }
        ArrayList<ConditionTreeNode> nodes = new ArrayList<ConditionTreeNode>();
        nodes.add(node);
        VariableTreeNode varNode = null;
        TreeNode parentNode = node.getParentNode();
        while (parentNode != null) {
            if (parentNode instanceof VariableTreeNode) {
                varNode = (VariableTreeNode)parentNode;
                this.buildCriterion(and, (ConditionTreeNode)parentNode.getParentNode());
                break;
            }
            if (!(parentNode instanceof ConditionTreeNode)) continue;
            ConditionTreeNode parentConditionTreeNode = (ConditionTreeNode)parentNode;
            nodes.add(parentConditionTreeNode);
            parentNode = parentConditionTreeNode.getParentNode();
        }
        if (varNode == null) {
            throw new RuleException("Decision tree is invalid.");
        }
        for (ConditionTreeNode cn : nodes) {
            and.addCriterion(this.buildCriteria(cn, varNode));
        }
    }

    private Criteria buildCriteria(ConditionTreeNode cn, VariableTreeNode varNode) {
        Criteria c = new Criteria();
        c.setLeft(varNode.getLeft());
        c.setOp(cn.getOp());
        c.setValue(cn.getValue());
        return c;
    }

    public void fetchActionTreeNodes(List<? extends TreeNode> nodes, List<ActionTreeNode> list) {
        for (TreeNode treeNode : nodes) {
            List<VariableTreeNode> varNodes;
            List<ConditionTreeNode> conditionNodes;
            if (treeNode instanceof ActionTreeNode) {
                list.add((ActionTreeNode)treeNode);
                continue;
            }
            if (treeNode instanceof VariableTreeNode) {
                VariableTreeNode vn = (VariableTreeNode)treeNode;
                List<ConditionTreeNode> conditionNodes2 = vn.getConditionTreeNodes();
                if (conditionNodes2 == null) continue;
                this.fetchActionTreeNodes(conditionNodes2, list);
                continue;
            }
            if (!(treeNode instanceof ConditionTreeNode)) continue;
            ConditionTreeNode cn = (ConditionTreeNode)treeNode;
            List<ActionTreeNode> actionNodes = cn.getActionTreeNodes();
            if (actionNodes != null) {
                this.fetchActionTreeNodes(actionNodes, list);
            }
            if ((conditionNodes = cn.getConditionTreeNodes()) != null) {
                this.fetchActionTreeNodes(conditionNodes, list);
            }
            if ((varNodes = cn.getVariableTreeNodes()) == null) continue;
            this.fetchActionTreeNodes(varNodes, list);
        }
    }
}

