/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.RuleException;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.builder.resource.ResourceBuilder;
import com.bstek.urule.builder.resource.ResourceProvider;
import java.util.Collection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractBuilder
implements ApplicationContextAware {
    protected Collection<ResourceProvider> providers;
    protected ApplicationContext applicationContext;
    protected Collection<ResourceBuilder> resourceBuilders;

    public ResourceBase newResourceBase() {
        return new ResourceBase(this.providers);
    }

    protected Element parseResource(String content) {
        try {
            Document document = DocumentHelper.parseText((String)content);
            Element root = document.getRootElement();
            return root;
        }
        catch (DocumentException e) {
            throw new RuleException((Exception)((Object)e));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resourceBuilders = applicationContext.getBeansOfType(ResourceBuilder.class).values();
        this.providers = applicationContext.getBeansOfType(ResourceProvider.class).values();
        this.applicationContext = applicationContext;
        applicationContext.getBeansWithAnnotation(SuppressWarnings.class);
    }
}

