/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.action;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.action.AbstractAction;
import com.bstek.urule.action.ActionType;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ValueCompute;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class VariableAssignAction
extends AbstractAction {
    private String referenceName;
    private String variableName;
    private String variableLabel;
    private String variableCategory;
    private Datatype datatype;
    private Value value;
    private LeftType type;
    private ActionType actionType = ActionType.VariableAssign;

    @Override
    public ActionValue execute(Context context, Object matchedObject, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        Object targetFact = null;
        String propertyName = null;
        ValueCompute valueCompute = context.getValueCompute();
        Object obj = valueCompute.complexValueCompute(this.value, matchedObject, context, allMatchedObjects, variableMap);
        String label = null;
        if (this.type != null && this.type.equals((Object)LeftType.NamedReference)) {
            String refName = this.referenceName;
            targetFact = variableMap.get(refName);
            if (targetFact == null) {
                refName = refName.substring(1, refName.length());
                targetFact = variableMap.get(refName);
            }
            if (targetFact == null) {
                throw new RuleException("Reference [" + this.referenceName + "] not define.");
            }
            propertyName = this.variableName;
            label = this.referenceName + "." + (this.variableLabel == null ? this.variableName : this.variableLabel);
        } else {
            String className = context.getVariableCategoryClass(this.variableCategory);
            targetFact = className.equals(HashMap.class.getName()) ? context.getWorkingMemory().getParameters() : valueCompute.findObject(className, matchedObject, context);
            if (targetFact == null) {
                throw new RuleException("Class[" + className + "] not found in workingmemory.");
            }
            if (this.datatype.equals((Object)Datatype.Enum) && obj != null && StringUtils.isNotBlank((String)obj.toString())) {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(targetFact.getClass(), (String)this.variableName);
                Class<?> targetClass = pd.getPropertyType();
                obj = Enum.valueOf(targetClass, obj.toString());
            } else if (obj != null) {
                obj = this.datatype.convert(obj);
            }
            propertyName = this.variableName;
            label = this.variableCategory + "." + (this.variableLabel == null ? this.variableName : this.variableLabel);
        }
        Utils.setObjectProperty(targetFact, propertyName, obj);
        if (this.debug && Utils.isDebug()) {
            String msg = "###\u53d8\u91cf\u8d4b\u503c\uff1a" + label + "=" + obj;
            context.debugMsg(msg, MsgType.VarAssign, this.debug);
        }
        return null;
    }

    public LeftType getType() {
        return this.type;
    }

    public void setType(LeftType type) {
        this.type = type;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableLabel() {
        return this.variableLabel;
    }

    public void setVariableLabel(String variableLabel) {
        this.variableLabel = variableLabel;
    }

    public String getVariableCategory() {
        return this.variableCategory;
    }

    public void setVariableCategory(String variableCategory) {
        this.variableCategory = variableCategory;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }
}

