/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.action;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.action.AbstractAction;
import com.bstek.urule.action.ActionId;
import com.bstek.urule.action.ActionType;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.action.ActionValueImpl;
import com.bstek.urule.action.ParametersWrap;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ValueCompute;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecuteMethodAction
extends AbstractAction {
    private String beanId;
    private String beanLabel;
    private String methodLabel;
    private String methodName;
    private List<Parameter> parameters;
    private ActionType actionType = ActionType.ExecuteMethod;

    @Override
    public ActionValue execute(Context context, Object matchedObject, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        String info = (this.beanLabel == null ? this.beanId : this.beanLabel) + (this.methodLabel == null ? this.methodName : this.methodLabel);
        info = "$$$\u6267\u884c\u52a8\u4f5c\uff1a" + info;
        try {
            Object obj = context.getApplicationContext().getBean(this.beanId);
            Method method = null;
            if (this.parameters != null && this.parameters.size() > 0) {
                ParametersWrap wrap = this.buildParameterClasses(context, matchedObject, allMatchedObjects, variableMap);
                Method[] methods = obj.getClass().getMethods();
                Datatype[] targetDatatypes = wrap.getDatatypes();
                boolean match = false;
                Method[] methodArray = methods;
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Datatype datatype;
                    Class<?> clazz;
                    Class<?>[] parameterClasses;
                    Method m;
                    method = m = methodArray[i];
                    String name = m.getName();
                    if (!name.equals(this.methodName) || (parameterClasses = m.getParameterTypes()).length != this.parameters.size()) continue;
                    for (int i2 = 0; i2 < parameterClasses.length && (match = this.classMatch(clazz = parameterClasses[i2], datatype = targetDatatypes[i2])); ++i2) {
                    }
                    if (match) break;
                }
                if (!match) {
                    throw new RuleException("Bean [" + this.beanId + "." + this.methodName + "] with " + this.parameters.size() + " parameters not exist");
                }
                String valueKey = this.methodName;
                ActionId actionId = method.getAnnotation(ActionId.class);
                if (actionId != null) {
                    valueKey = actionId.value();
                }
                Object value = method.invoke(obj, wrap.getValues());
                if (this.debug && Utils.isDebug()) {
                    String msg = info + "(" + wrap.valuesToString() + ")";
                    context.debugMsg(msg, MsgType.ExecuteBeanMethod, this.debug);
                }
                if (value != null) {
                    return new ActionValueImpl(valueKey, value);
                }
                return null;
            }
            method = obj.getClass().getMethod(this.methodName, new Class[0]);
            String valueKey = this.methodName;
            ActionId actionId = method.getAnnotation(ActionId.class);
            if (actionId != null) {
                valueKey = actionId.value();
            }
            Object value = method.invoke(obj, new Object[0]);
            if (this.debug && Utils.isDebug()) {
                String msg = info + "()";
                context.debugMsg(msg, MsgType.ExecuteBeanMethod, this.debug);
            }
            if (value != null) {
                return new ActionValueImpl(valueKey, value);
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    private boolean classMatch(Class<?> clazz, Datatype datatype) {
        boolean match = false;
        switch (datatype) {
            case String: {
                if (clazz.equals(String.class)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case BigDecimal: {
                if (clazz.equals(BigDecimal.class)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Boolean: {
                if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Date: {
                if (clazz.equals(Date.class)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Double: {
                if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Enum: {
                if (Enum.class.isAssignableFrom(clazz)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Float: {
                if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Integer: {
                if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Char: {
                if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case List: {
                if (List.class.isAssignableFrom(clazz)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Long: {
                if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Map: {
                if (Map.class.isAssignableFrom(clazz)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Set: {
                if (Set.class.isAssignableFrom(clazz)) {
                    match = true;
                    break;
                }
                match = false;
                break;
            }
            case Object: {
                match = true;
            }
        }
        return match;
    }

    private ParametersWrap buildParameterClasses(Context context, Object matchedObject, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        ArrayList<Datatype> list = new ArrayList<Datatype>();
        ArrayList<Object> values = new ArrayList<Object>();
        ValueCompute valueCompute = context.getValueCompute();
        for (Parameter param : this.parameters) {
            Datatype type = param.getType();
            list.add(type);
            Object value = valueCompute.complexValueCompute(param.getValue(), matchedObject, context, allMatchedObjects, variableMap);
            values.add(type.convert(value));
        }
        Datatype[] datatypes = new Datatype[list.size()];
        list.toArray(datatypes);
        Object[] objs = new Object[values.size()];
        values.toArray(objs);
        ParametersWrap wrap = new ParametersWrap();
        wrap.setDatatypes(datatypes);
        wrap.setValues(objs);
        return wrap;
    }

    public String getMethodLabel() {
        return this.methodLabel;
    }

    public void setMethodLabel(String methodLabel) {
        this.methodLabel = methodLabel;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getBeanLabel() {
        return this.beanLabel;
    }

    public void setBeanLabel(String beanLabel) {
        this.beanLabel = beanLabel;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }
}

