/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.action;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.action.AbstractAction;
import com.bstek.urule.action.ActionType;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.action.ActionValueImpl;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.runtime.rete.Context;
import java.util.List;
import java.util.Map;

public class ExecuteCommonFunctionAction
extends AbstractAction {
    private String name;
    private String label;
    private CommonFunctionParameter parameter;

    @Override
    public ActionValue execute(Context context, Object matchedObject, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        FunctionDescriptor function = null;
        if (Utils.getFunctionDescriptorMap().containsKey(this.name)) {
            function = Utils.findFunctionDescriptor(this.name);
        } else if (Utils.getFunctionDescriptorLabelMap().containsKey(this.label)) {
            function = Utils.getFunctionDescriptorLabelMap().get(this.label);
        }
        if (function == null) {
            throw new RuleException("Function[" + this.name + "] not exist.");
        }
        String info = this.label == null ? this.name : this.label;
        Value value = null;
        Object object = null;
        if (this.parameter != null) {
            value = this.parameter.getObjectParameter();
            object = context.getValueCompute().complexValueCompute(value, matchedObject, context, allMatchedObjects, variableMap);
        }
        String property = null;
        if (function.getArgument() != null && function.getArgument().isNeedProperty()) {
            property = this.parameter.getProperty();
        }
        Object result = function.doFunction(object, property, context.getWorkingMemory());
        if (this.debug && Utils.isDebug()) {
            info = info + (object == null ? "" : object);
            String msg = "***\u6267\u884c\u51fd\u6570\uff1a" + info;
            context.debugMsg(msg, MsgType.ExecuteFunction, this.debug);
        }
        if (result != null) {
            return new ActionValueImpl(this.name, result);
        }
        return null;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ExecuteCommonFunction;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public CommonFunctionParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(CommonFunctionParameter parameter) {
        this.parameter = parameter;
    }
}

