/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule;

import com.bstek.urule.RuleException;
import com.bstek.urule.Splash;
import com.bstek.urule.debug.DebugWriter;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.library.Datatype;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Utils
implements ApplicationContextAware {
    private static boolean debug;
    private static boolean debugToFile;
    private static ApplicationContext applicationContext;
    private static Collection<DebugWriter> debugWriters;
    private static Map<String, FunctionDescriptor> functionDescriptorMap;
    private static Map<String, FunctionDescriptor> functionDescriptorLabelMap;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static String decodeURL(String str) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        try {
            str = URLDecoder.decode(str, "utf-8");
            str = URLDecoder.decode(str, "utf-8");
            return str;
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String encodeURL(String str) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuleException(e);
        }
    }

    public static String toUTF8(String text) {
        try {
            if (text == null) {
                return null;
            }
            byte[] fileBytes = text.getBytes("iso8859-1");
            boolean isiso = text.equals(new String(fileBytes, "iso8859-1"));
            if (isiso) {
                text = new String(fileBytes, "utf-8");
            }
            if (isiso = text.equals(new String(text.getBytes("iso8859-1"), "iso8859-1"))) {
                text = new String(fileBytes, "utf-8");
            }
            return text;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    public static Object getObjectProperty(Object object, String property) {
        try {
            return PropertyUtils.getProperty((Object)object, (String)property);
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    public static void setObjectProperty(Object object, String property, Object value) {
        try {
            BeanUtils.setProperty((Object)object, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    public static Datatype getDatatype(Object obj) {
        Datatype datatype = null;
        datatype = obj == null ? Datatype.Object : (obj instanceof Integer ? Datatype.Integer : (obj instanceof Long ? Datatype.Long : (obj instanceof Double ? Datatype.Double : (obj instanceof Float ? Datatype.Float : (obj instanceof BigDecimal ? Datatype.BigDecimal : (obj instanceof Boolean ? Datatype.Boolean : (obj instanceof Date ? Datatype.Date : (obj instanceof List ? Datatype.List : (obj instanceof Set ? Datatype.Set : (obj instanceof Enum ? Datatype.Enum : (obj instanceof Map ? Datatype.Map : (obj instanceof String ? Datatype.String : (obj instanceof Character ? Datatype.Char : Datatype.Object)))))))))))));
        return datatype;
    }

    public static BigDecimal toBigDecimal(Object val) {
        try {
            if (val instanceof BigDecimal) {
                return (BigDecimal)val;
            }
            if (val == null) {
                throw new IllegalArgumentException("Null can not to BigDecimal.");
            }
            if (val instanceof String) {
                String str = (String)val;
                if ("".equals(str.trim())) {
                    return BigDecimal.valueOf(0L);
                }
                str = str.trim();
                return new BigDecimal(str);
            }
            if (val instanceof Number) {
                return new BigDecimal(val.toString());
            }
            if (val instanceof Character) {
                char i = ((Character)val).charValue();
                return new BigDecimal(i);
            }
        }
        catch (Exception ex) {
            throw new NumberFormatException("Can not convert " + val + " to number.");
        }
        throw new IllegalArgumentException(val.getClass().getName() + " can not to BigDecimal.");
    }

    public static FunctionDescriptor findFunctionDescriptor(String functionName) {
        if (!functionDescriptorMap.containsKey(functionName)) {
            throw new RuleException("Function[" + functionName + "] not exist.");
        }
        return functionDescriptorMap.get(functionName);
    }

    public static Map<String, FunctionDescriptor> getFunctionDescriptorLabelMap() {
        return functionDescriptorLabelMap;
    }

    public static Map<String, FunctionDescriptor> getFunctionDescriptorMap() {
        return functionDescriptorMap;
    }

    public void setDebug(boolean debug) {
        Utils.debug = debug;
    }

    public void setDebugToFile(boolean debugToFile) {
        Utils.debugToFile = debugToFile;
    }

    public static boolean isDebugToFile() {
        return debugToFile;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static Collection<DebugWriter> getDebugWriters() {
        return debugWriters;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        functionDescriptorMap.clear();
        functionDescriptorLabelMap.clear();
        Collection functionDescriptors = applicationContext.getBeansOfType(FunctionDescriptor.class).values();
        for (FunctionDescriptor fun : functionDescriptors) {
            if (fun.isDisabled()) continue;
            if (functionDescriptorMap.containsKey(fun.getName())) {
                throw new RuntimeException("Duplicate function [" + fun.getName() + "]");
            }
            functionDescriptorMap.put(fun.getName(), fun);
            functionDescriptorLabelMap.put(fun.getLabel(), fun);
        }
        debugWriters = applicationContext.getBeansOfType(DebugWriter.class).values();
        Utils.applicationContext = applicationContext;
        new Splash().print();
    }

    static {
        functionDescriptorMap = new HashMap<String, FunctionDescriptor>();
        functionDescriptorLabelMap = new HashMap<String, FunctionDescriptor>();
    }
}

