/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule;

import com.bstek.urule.model.Label;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Act;
import com.bstek.urule.model.library.variable.Variable;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ClassUtils {
    public static void classToXml(Class<?> cls, File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            List<Variable> variables = ClassUtils.classToVariables(cls);
            StringBuffer sb = new StringBuffer();
            sb.append("<variables clazz=\"" + cls.getName() + "\">");
            for (Variable var : variables) {
                sb.append("<variable ");
                sb.append("name=\"" + var.getName() + "\" ");
                if (var.getLabel() != null) {
                    sb.append("label=\"" + var.getLabel() + "\" ");
                }
                if (var.getDefaultValue() != null) {
                    sb.append("defaultValue=\"" + var.getDefaultValue() + "\" ");
                }
                if (var.getType() != null) {
                    sb.append("type=\"" + (Object)((Object)var.getType()) + "\" ");
                }
                if (var.getAct() != null) {
                    sb.append("act=\"" + (Object)((Object)var.getAct()) + "\" ");
                }
                sb.append(">");
                sb.append("</variable>");
            }
            sb.append("</variables>");
            Document doc = DocumentHelper.parseText((String)sb.toString());
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("utf-8");
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static List<Variable> classToVariables(Class<?> cls) {
        try {
            List<Variable> result = ClassUtils.paserClass("", cls, new ArrayList());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Variable> paserClass(String path, Class<?> cls, Collection<Class<?>> parsed) throws Exception {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        BeanInfo beanInfo = Introspector.getBeanInfo(cls, Object.class);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        if (pds != null && !parsed.contains(cls)) {
            parsed.add(cls);
            for (PropertyDescriptor pd : pds) {
                Variable variable = new Variable();
                Class<?> type = pd.getPropertyType();
                Datatype dataType = ClassUtils.getDateType(type);
                String propertyName = pd.getName();
                String label = ClassUtils.getPropertyAnnotationLabel(cls, propertyName);
                String name = path + pd.getName();
                variable.setName(name);
                variable.setLabel(label == null ? name : label);
                variable.setType(dataType);
                variable.setAct(Act.InOut);
                if (Datatype.Object.equals((Object)dataType)) {
                    variables.addAll(ClassUtils.paserClass(path + pd.getName() + ".", type, parsed));
                    continue;
                }
                variables.add(variable);
            }
        }
        return variables;
    }

    private static String getPropertyAnnotationLabel(Class<?> cls, String fieldName) throws Exception {
        Field field = null;
        while (field == null) {
            try {
                field = cls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                if (cls == Object.class) {
                    throw ex;
                }
                cls = cls.getSuperclass();
            }
        }
        Label pd = field.getAnnotation(Label.class);
        if (pd != null) {
            return pd.value();
        }
        return null;
    }

    private static Datatype getDateType(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return Datatype.String;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Datatype.Boolean;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Datatype.Integer;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Datatype.Float;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Datatype.Long;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return Datatype.BigDecimal;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Datatype.Double;
        }
        if (Date.class.isAssignableFrom(type)) {
            return Datatype.Date;
        }
        if (Date.class.isAssignableFrom(type)) {
            return Datatype.Date;
        }
        if (List.class.isAssignableFrom(type)) {
            return Datatype.List;
        }
        if (Map.class.isAssignableFrom(type)) {
            return Datatype.Map;
        }
        if (Set.class.isAssignableFrom(type)) {
            return Datatype.Set;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Datatype.Enum;
        }
        if (Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) {
            return Datatype.Char;
        }
        return Datatype.Object;
    }
}

