/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.util.FileUtils;
import com.baomidou.mybatisplus.generator.util.RuntimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateEngine {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ConfigBuilder configBuilder;

    @NotNull
    public abstract AbstractTemplateEngine init(@NotNull ConfigBuilder var1);

    protected void outputCustomFile(@NotNull List<CustomFile> customFiles, @NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String parentPath = this.getPathInfo(OutputFile.parent);
        customFiles.forEach(file -> {
            String filePath;
            String string = filePath = StringUtils.isNotBlank((CharSequence)file.getFilePath()) ? file.getFilePath() : parentPath;
            if (StringUtils.isNotBlank((CharSequence)file.getPackageName())) {
                filePath = filePath + File.separator + file.getPackageName().replaceAll("\\.", "\\" + File.separator);
            }
            Function<TableInfo, String> formatNameFunction = file.getFormatNameFunction();
            String fileName = filePath + File.separator + (null != formatNameFunction ? formatNameFunction.apply(tableInfo) : entityName) + file.getFileName();
            this.outputFile(new File(fileName), objectMap, file.getTemplatePath(), file.isFileOverride());
        });
    }

    protected void outputEntity(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String entityPath = this.getPathInfo(OutputFile.entity);
        if (StringUtils.isNotBlank((CharSequence)entityName) && StringUtils.isNotBlank((CharSequence)entityPath)) {
            this.getTemplateFilePath(template -> template.getEntity(this.getConfigBuilder().getGlobalConfig().isKotlin())).ifPresent(entity -> {
                String entityFile = String.format(entityPath + File.separator + "%s" + this.suffixJavaOrKt(), entityName);
                this.outputFile(this.getOutputFile(entityFile, OutputFile.entity), objectMap, (String)entity, this.getConfigBuilder().getStrategyConfig().entity().isFileOverride());
            });
        }
    }

    protected File getOutputFile(String filePath, OutputFile outputFile) {
        return this.getConfigBuilder().getStrategyConfig().getOutputFile().createFile(filePath, outputFile);
    }

    protected void outputMapper(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String mapperPath = this.getPathInfo(OutputFile.mapper);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getMapperName()) && StringUtils.isNotBlank((CharSequence)mapperPath)) {
            this.getTemplateFilePath(TemplateConfig::getMapper).ifPresent(mapper -> {
                String mapperFile = String.format(mapperPath + File.separator + tableInfo.getMapperName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(this.getOutputFile(mapperFile, OutputFile.mapper), objectMap, (String)mapper, this.getConfigBuilder().getStrategyConfig().mapper().isFileOverride());
            });
        }
        String xmlPath = this.getPathInfo(OutputFile.xml);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getXmlName()) && StringUtils.isNotBlank((CharSequence)xmlPath)) {
            this.getTemplateFilePath(TemplateConfig::getXml).ifPresent(xml -> {
                String xmlFile = String.format(xmlPath + File.separator + tableInfo.getXmlName() + ".xml", entityName);
                this.outputFile(this.getOutputFile(xmlFile, OutputFile.xml), objectMap, (String)xml, this.getConfigBuilder().getStrategyConfig().mapper().isFileOverride());
            });
        }
    }

    protected void outputService(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        if (tableInfo.isServiceInterface()) {
            String servicePath = this.getPathInfo(OutputFile.service);
            if (StringUtils.isNotBlank((CharSequence)tableInfo.getServiceName()) && StringUtils.isNotBlank((CharSequence)servicePath)) {
                this.getTemplateFilePath(TemplateConfig::getService).ifPresent(service -> {
                    String serviceFile = String.format(servicePath + File.separator + tableInfo.getServiceName() + this.suffixJavaOrKt(), entityName);
                    this.outputFile(this.getOutputFile(serviceFile, OutputFile.service), objectMap, (String)service, this.getConfigBuilder().getStrategyConfig().service().isFileOverride());
                });
            }
        }
        String serviceImplPath = this.getPathInfo(OutputFile.serviceImpl);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getServiceImplName()) && StringUtils.isNotBlank((CharSequence)serviceImplPath)) {
            this.getTemplateFilePath(TemplateConfig::getServiceImpl).ifPresent(serviceImpl -> {
                String implFile = String.format(serviceImplPath + File.separator + tableInfo.getServiceImplName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(this.getOutputFile(implFile, OutputFile.serviceImpl), objectMap, (String)serviceImpl, this.getConfigBuilder().getStrategyConfig().service().isFileOverride());
            });
        }
    }

    protected void outputController(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String controllerPath = this.getPathInfo(OutputFile.controller);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getControllerName()) && StringUtils.isNotBlank((CharSequence)controllerPath)) {
            this.getTemplateFilePath(TemplateConfig::getController).ifPresent(controller -> {
                String entityName = tableInfo.getEntityName();
                String controllerFile = String.format(controllerPath + File.separator + tableInfo.getControllerName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(this.getOutputFile(controllerFile, OutputFile.controller), objectMap, (String)controller, this.getConfigBuilder().getStrategyConfig().controller().isFileOverride());
            });
        }
    }

    protected void outputFile(@NotNull File file, @NotNull Map<String, Object> objectMap, @NotNull String templatePath, boolean fileOverride) {
        if (this.isCreate(file, fileOverride)) {
            try {
                boolean exist = file.exists();
                if (!exist) {
                    File parentFile = file.getParentFile();
                    FileUtils.forceMkdir(parentFile);
                }
                this.writer(objectMap, templatePath, file);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @NotNull
    protected Optional<String> getTemplateFilePath(@NotNull Function<TemplateConfig, String> function) {
        TemplateConfig templateConfig = this.getConfigBuilder().getTemplateConfig();
        String filePath = function.apply(templateConfig);
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            return Optional.of(this.templateFilePath(filePath));
        }
        return Optional.empty();
    }

    @Nullable
    protected String getPathInfo(@NotNull OutputFile outputFile) {
        return this.getConfigBuilder().getPathInfo().get((Object)outputFile);
    }

    @NotNull
    public AbstractTemplateEngine batchOutput() {
        try {
            ConfigBuilder config = this.getConfigBuilder();
            List<TableInfo> tableInfoList = config.getTableInfoList();
            tableInfoList.forEach(tableInfo -> {
                Map<String, Object> objectMap = this.getObjectMap(config, (TableInfo)tableInfo);
                Optional.ofNullable(config.getInjectionConfig()).ifPresent(t -> {
                    t.beforeOutputFile((TableInfo)tableInfo, objectMap);
                    this.outputCustomFile(t.getCustomFiles(), (TableInfo)tableInfo, objectMap);
                });
                this.outputEntity((TableInfo)tableInfo, objectMap);
                this.outputMapper((TableInfo)tableInfo, objectMap);
                this.outputService((TableInfo)tableInfo, objectMap);
                this.outputController((TableInfo)tableInfo, objectMap);
            });
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", e);
        }
        return this;
    }

    @NotNull
    public abstract void writer(@NotNull Map<String, Object> var1, @NotNull String var2, @NotNull File var3) throws Exception;

    public void open() {
        String outDir = this.getConfigBuilder().getGlobalConfig().getOutputDir();
        if (StringUtils.isBlank((CharSequence)outDir) || !new File(outDir).exists()) {
            System.err.println("\u672a\u627e\u5230\u8f93\u51fa\u76ee\u5f55\uff1a" + outDir);
        } else if (this.getConfigBuilder().getGlobalConfig().isOpen()) {
            try {
                RuntimeUtils.openDir(outDir);
            }
            catch (IOException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @NotNull
    public Map<String, Object> getObjectMap(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        StrategyConfig strategyConfig = config.getStrategyConfig();
        Map<String, Object> controllerData = strategyConfig.controller().renderData(tableInfo);
        HashMap<String, Object> objectMap = new HashMap<String, Object>(controllerData);
        Map<String, Object> mapperData = strategyConfig.mapper().renderData(tableInfo);
        objectMap.putAll(mapperData);
        Map<String, Object> serviceData = strategyConfig.service().renderData(tableInfo);
        objectMap.putAll(serviceData);
        Map<String, Object> entityData = strategyConfig.entity().renderData(tableInfo);
        objectMap.putAll(entityData);
        objectMap.put("config", config);
        objectMap.put("package", config.getPackageConfig().getPackageInfo());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger", globalConfig.isSwagger());
        objectMap.put("springdoc", globalConfig.isSpringdoc());
        objectMap.put("date", globalConfig.getCommentDate());
        String schemaName = "";
        if (strategyConfig.isEnableSchema() && StringUtils.isNotBlank((CharSequence)(schemaName = config.getDataSourceConfig().getSchemaName()))) {
            schemaName = schemaName + ".";
            tableInfo.setConvert(true);
        }
        objectMap.put("schemaName", schemaName);
        objectMap.put("table", tableInfo);
        objectMap.put("entity", tableInfo.getEntityName());
        return objectMap;
    }

    @NotNull
    public abstract String templateFilePath(@NotNull String var1);

    protected boolean isCreate(@NotNull File file, boolean fileOverride) {
        if (file.exists() && !fileOverride) {
            this.LOGGER.warn("\u6587\u4ef6[{}]\u5df2\u5b58\u5728\uff0c\u4e14\u672a\u5f00\u542f\u6587\u4ef6\u8986\u76d6\u914d\u7f6e\uff0c\u9700\u8981\u5f00\u542f\u914d\u7f6e\u53ef\u5230\u7b56\u7565\u914d\u7f6e\u4e2d\u8bbe\u7f6e\uff01\uff01\uff01", (Object)file.getName());
        }
        return !file.exists() || fileOverride;
    }

    protected String suffixJavaOrKt() {
        return this.getConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    @NotNull
    public ConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    @NotNull
    public AbstractTemplateEngine setConfigBuilder(@NotNull ConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
        return this;
    }
}

