/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeUtils.class);

    public static void openDir(String outDir) throws IOException {
        File file = new File(outDir);
        if (!file.isDirectory()) {
            LOGGER.error("illegal directory:{}", (Object)outDir);
            throw new IllegalArgumentException("Illegal directory " + outDir);
        }
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.contains("Mac")) {
                Runtime.getRuntime().exec("open " + outDir);
            } else if (osName.contains("Windows")) {
                Runtime.getRuntime().exec(MessageFormat.format("cmd /c start \"\" \"{0}\"", outDir));
            } else {
                LOGGER.debug("file output directory:{}", (Object)outDir);
            }
        } else {
            LOGGER.warn("read operating system failed!");
        }
    }
}

