/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.engine;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private Configuration configuration;

    @Override
    @NotNull
    public FreemarkerTemplateEngine init(@NotNull ConfigBuilder configBuilder) {
        this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.configuration.setDefaultEncoding(ConstVal.UTF8);
        this.configuration.setClassForTemplateLoading(FreemarkerTemplateEngine.class, "/");
        return this;
    }

    @Override
    public String writer(@NotNull Map<String, Object> objectMap, @NotNull String templateName, @NotNull String templateString) throws Exception {
        Template template = new Template(templateName, templateString, this.configuration);
        StringWriter writer = new StringWriter();
        template.process(objectMap, (Writer)writer);
        return writer.toString();
    }

    @Override
    public void writer(@NotNull Map<String, Object> objectMap, @NotNull String templatePath, @NotNull File outputFile) throws Exception {
        Template template = this.configuration.getTemplate(templatePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            template.process(objectMap, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, ConstVal.UTF8));
        }
    }

    @Override
    @NotNull
    public String templateFilePath(@NotNull String filePath) {
        return filePath + ".ftl";
    }
}

