/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.aop;

import com.baomidou.lock.LockFailureStrategy;
import com.baomidou.lock.LockInfo;
import com.baomidou.lock.LockKeyBuilder;
import com.baomidou.lock.LockTemplate;
import com.baomidou.lock.annotation.Lock4j;
import com.baomidou.lock.spring.boot.autoconfigure.Lock4jProperties;
import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class LockInterceptor
implements MethodInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LockInterceptor.class);
    private final Map<Class<? extends LockKeyBuilder>, LockKeyBuilder> keyBuilderMap = new LinkedHashMap<Class<? extends LockKeyBuilder>, LockKeyBuilder>();
    private final Map<Class<? extends LockFailureStrategy>, LockFailureStrategy> failureStrategyMap = new LinkedHashMap<Class<? extends LockFailureStrategy>, LockFailureStrategy>();
    private final LockTemplate lockTemplate;
    private final List<LockKeyBuilder> keyBuilders;
    private final List<LockFailureStrategy> failureStrategies;
    private final Lock4jProperties lock4jProperties;
    private LockOperation primaryLockOperation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object var8_9;
        block7: {
            boolean releaseLock;
            String key;
            LockOperation lockOperation;
            LockInfo lockInfo;
            Lock4j lock4j;
            block5: {
                Object object;
                block6: {
                    Class cls = AopProxyUtils.ultimateTargetClass((Object)invocation.getThis());
                    if (!cls.equals(invocation.getThis().getClass())) {
                        return invocation.proceed();
                    }
                    lock4j = (Lock4j)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.getMethod(), Lock4j.class);
                    lockInfo = null;
                    try {
                        boolean releaseLock2;
                        lockOperation = this.buildLockOperation(lock4j);
                        String prefix = this.lock4jProperties.getLockKeyPrefix() + ":";
                        prefix = prefix + (StringUtils.hasText((String)lock4j.name()) ? lock4j.name() : invocation.getMethod().getDeclaringClass().getName() + invocation.getMethod().getName());
                        key = prefix + "#" + lockOperation.lockKeyBuilder.buildKey(invocation, lock4j.keys());
                        lockInfo = this.lockTemplate.lock(key, lock4j.expire(), lock4j.acquireTimeout(), lock4j.executor());
                        if (null == lockInfo) break block5;
                        object = invocation.proceed();
                        if (null == lockInfo || !lock4j.autoRelease() || (releaseLock2 = this.lockTemplate.releaseLock(lockInfo))) break block6;
                    }
                    catch (Throwable throwable) {
                        boolean releaseLock3;
                        if (null != lockInfo && lock4j.autoRelease() && !(releaseLock3 = this.lockTemplate.releaseLock(lockInfo))) {
                            log.error("releaseLock fail,lockKey={},lockValue={}", (Object)lockInfo.getLockKey(), (Object)lockInfo.getLockValue());
                        }
                        throw throwable;
                    }
                    log.error("releaseLock fail,lockKey={},lockValue={}", (Object)lockInfo.getLockKey(), (Object)lockInfo.getLockValue());
                }
                return object;
            }
            lockOperation.lockFailureStrategy.onLockFailure(key, invocation.getMethod(), invocation.getArguments());
            var8_9 = null;
            if (null == lockInfo || !lock4j.autoRelease() || (releaseLock = this.lockTemplate.releaseLock(lockInfo))) break block7;
            log.error("releaseLock fail,lockKey={},lockValue={}", (Object)lockInfo.getLockKey(), (Object)lockInfo.getLockValue());
        }
        return var8_9;
    }

    public void afterPropertiesSet() {
        LockFailureStrategy lockFailureStrategy;
        LockKeyBuilder lockKeyBuilder;
        this.keyBuilderMap.putAll(this.keyBuilders.stream().collect(Collectors.toMap(Object::getClass, x -> x)));
        this.failureStrategyMap.putAll(this.failureStrategies.stream().collect(Collectors.toMap(Object::getClass, x -> x)));
        List priorityOrderedLockBuilders = this.keyBuilders.stream().filter(Ordered.class::isInstance).collect(Collectors.toList());
        if (this.lock4jProperties.getPrimaryKeyBuilder() != null) {
            lockKeyBuilder = this.keyBuilderMap.get(this.lock4jProperties.getPrimaryKeyBuilder());
        } else if (!priorityOrderedLockBuilders.isEmpty()) {
            this.sortOperation(priorityOrderedLockBuilders);
            lockKeyBuilder = (LockKeyBuilder)priorityOrderedLockBuilders.get(0);
        } else {
            lockKeyBuilder = this.keyBuilders.get(0);
        }
        List priorityOrderedFailures = this.failureStrategies.stream().filter(Ordered.class::isInstance).collect(Collectors.toList());
        if (this.lock4jProperties.getPrimaryFailureStrategy() != null) {
            lockFailureStrategy = this.failureStrategyMap.get(this.lock4jProperties.getPrimaryFailureStrategy());
        } else if (!priorityOrderedFailures.isEmpty()) {
            this.sortOperation(priorityOrderedFailures);
            lockFailureStrategy = (LockFailureStrategy)priorityOrderedFailures.get(0);
        } else {
            lockFailureStrategy = this.failureStrategies.get(0);
        }
        this.primaryLockOperation = LockOperation.builder().lockKeyBuilder(lockKeyBuilder).lockFailureStrategy(lockFailureStrategy).build();
    }

    private LockOperation buildLockOperation(Lock4j lock4j) {
        Class<? extends LockFailureStrategy> failStrategy = lock4j.failStrategy();
        Class<? extends LockKeyBuilder> keyBuilderStrategy = lock4j.keyBuilderStrategy();
        LockKeyBuilder lockKeyBuilder = keyBuilderStrategy == null || keyBuilderStrategy == LockKeyBuilder.class ? this.primaryLockOperation.lockKeyBuilder : this.keyBuilderMap.get(keyBuilderStrategy);
        LockFailureStrategy lockFailureStrategy = failStrategy == null || failStrategy == LockFailureStrategy.class ? this.primaryLockOperation.lockFailureStrategy : this.failureStrategyMap.get(failStrategy);
        return LockOperation.builder().lockKeyBuilder(lockKeyBuilder).lockFailureStrategy(lockFailureStrategy).build();
    }

    private void sortOperation(List<?> operations) {
        if (operations.size() <= 1) {
            return;
        }
        operations.sort((Comparator<?>)OrderComparator.INSTANCE);
    }

    public LockInterceptor(LockTemplate lockTemplate, List<LockKeyBuilder> keyBuilders, List<LockFailureStrategy> failureStrategies, Lock4jProperties lock4jProperties) {
        this.lockTemplate = lockTemplate;
        this.keyBuilders = keyBuilders;
        this.failureStrategies = failureStrategies;
        this.lock4jProperties = lock4jProperties;
    }

    private static class LockOperation {
        private LockKeyBuilder lockKeyBuilder;
        private LockFailureStrategy lockFailureStrategy;

        LockOperation(LockKeyBuilder lockKeyBuilder, LockFailureStrategy lockFailureStrategy) {
            this.lockKeyBuilder = lockKeyBuilder;
            this.lockFailureStrategy = lockFailureStrategy;
        }

        public static LockOperationBuilder builder() {
            return new LockOperationBuilder();
        }

        public static class LockOperationBuilder {
            private LockKeyBuilder lockKeyBuilder;
            private LockFailureStrategy lockFailureStrategy;

            LockOperationBuilder() {
            }

            public LockOperationBuilder lockKeyBuilder(LockKeyBuilder lockKeyBuilder) {
                this.lockKeyBuilder = lockKeyBuilder;
                return this;
            }

            public LockOperationBuilder lockFailureStrategy(LockFailureStrategy lockFailureStrategy) {
                this.lockFailureStrategy = lockFailureStrategy;
                return this;
            }

            public LockOperation build() {
                return new LockOperation(this.lockKeyBuilder, this.lockFailureStrategy);
            }

            public String toString() {
                return "LockInterceptor.LockOperation.LockOperationBuilder(lockKeyBuilder=" + this.lockKeyBuilder + ", lockFailureStrategy=" + this.lockFailureStrategy + ")";
            }
        }
    }
}

