/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.PatternMatchUtils;

public class DynamicDatasourceNamedInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicDatasourceNamedInterceptor.class);
    private static final String DYNAMIC_PREFIX = "#";
    private final Map<String, String> nameMap = new HashMap<String, String>();
    private final DsProcessor dsProcessor;

    public DynamicDatasourceNamedInterceptor(DsProcessor dsProcessor) {
        this.dsProcessor = dsProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
        String dsKey = this.determineDatasourceKey(invocation);
        DynamicDataSourceContextHolder.push(dsKey);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    public void addPattern(@Nonnull String methodName, @Nonnull String dsKey) {
        log.debug("dynamic-datasource adding ds method [" + methodName + "] with attribute [" + dsKey + "]");
        this.nameMap.put(methodName, dsKey);
    }

    public void addPatternMap(Map<String, String> map) {
        for (Map.Entry<String, String> item : map.entrySet()) {
            this.addPattern(item.getKey(), item.getValue());
        }
    }

    public void fromProperties(@Nonnull Properties properties) {
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String methodName = (String)propNames.nextElement();
            String value = properties.getProperty(methodName);
            this.addPattern(methodName, value);
        }
    }

    private boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    private String determineDatasourceKey(MethodInvocation invocation) {
        String key = this.findDsKey(invocation);
        return key != null && key.startsWith(DYNAMIC_PREFIX) ? this.dsProcessor.determineDatasource(invocation, key) : key;
    }

    private String findDsKey(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        if (!ClassUtils.isUserLevelMethod((Method)method)) {
            return null;
        }
        String methodName = method.getName();
        String dsKey = this.nameMap.get(methodName);
        if (dsKey == null) {
            String bestNameMatch = null;
            for (String mappedName : this.nameMap.keySet()) {
                boolean match2;
                boolean match1 = this.isMatch(methodName, mappedName);
                boolean bl = match2 = bestNameMatch == null || bestNameMatch.length() <= mappedName.length();
                if (!match1 || !match2) continue;
                dsKey = this.nameMap.get(mappedName);
                bestNameMatch = mappedName;
            }
        }
        return dsKey;
    }
}

