/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.hussar.extend;

import com.baomidou.dynamic.datasource.hussar.extend.HussarDataSourceProxy;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.ConnectionProxy;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.StringUtils;

public abstract class AbstractHussarDataSource
extends AbstractDataSource
implements HussarDataSourceProxy {
    private String poolName;
    private DbType dbType;
    private String driverClassName;
    private String url;
    private String username;
    private String password;

    public AbstractHussarDataSource() {
    }

    public AbstractHussarDataSource(String poolName, DbType dbType, String driverClassName, String url, String username, String password) {
        this.poolName = poolName;
        this.dbType = dbType;
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    protected abstract DataSource determineDataSource();

    @Override
    public DataSource getTargetDataSource() {
        return this.determineDataSource();
    }

    @Override
    public Connection getConnection() throws SQLException {
        String xid = TransactionContext.getXID();
        if (StringUtils.isEmpty((Object)xid)) {
            return this.determineDataSource().getConnection();
        }
        String ds = DynamicDataSourceContextHolder.peek();
        ds = StringUtils.isEmpty((Object)ds) ? "default" : ds;
        ConnectionProxy connection = ConnectionFactory.getConnection(ds);
        return connection == null ? this.getConnectionProxy(ds, this.determineDataSource().getConnection()) : connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String xid = TransactionContext.getXID();
        if (StringUtils.isEmpty((Object)xid)) {
            return this.determineDataSource().getConnection(username, password);
        }
        String ds = DynamicDataSourceContextHolder.peek();
        ds = StringUtils.isEmpty((Object)ds) ? "default" : ds;
        ConnectionProxy connection = ConnectionFactory.getConnection(ds);
        return connection == null ? this.getConnectionProxy(ds, this.determineDataSource().getConnection(username, password)) : connection;
    }

    private Connection getConnectionProxy(String ds, Connection connection) {
        ConnectionProxy connectionProxy = new ConnectionProxy(connection, ds);
        ConnectionFactory.putConnection(ds, connectionProxy);
        return connectionProxy;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.getTargetDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.getTargetDataSource().isWrapperFor(iface);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

