/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class LocalTxUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalTxUtil.class);

    public static void startTransaction() {
        if (!StringUtils.isEmpty((Object)TransactionContext.getXID())) {
            log.debug("dynamic-datasource exist local tx [{}]", (Object)TransactionContext.getXID());
        } else {
            String xid = UUID.randomUUID().toString();
            TransactionContext.bind(xid);
            log.debug("dynamic-datasource start local tx [{}]", (Object)xid);
        }
    }

    public static void commit() {
        ConnectionFactory.notify(true);
        log.debug("dynamic-datasource commit local tx [{}]", (Object)TransactionContext.getXID());
        TransactionContext.remove();
    }

    public static void rollback() {
        ConnectionFactory.notify(false);
        log.debug("dynamic-datasource rollback local tx [{}]", (Object)TransactionContext.getXID());
        TransactionContext.remove();
    }
}

