/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.tx.LocalTxUtil;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.StringUtils;

public class DynamicLocalTransactionInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object o;
        if (!StringUtils.isEmpty((Object)TransactionContext.getXID())) {
            return methodInvocation.proceed();
        }
        boolean state = true;
        LocalTxUtil.startTransaction();
        try {
            o = methodInvocation.proceed();
        }
        catch (Exception e) {
            state = false;
            throw e;
        }
        finally {
            if (state) {
                LocalTxUtil.commit();
            } else {
                LocalTxUtil.rollback();
            }
        }
        return o;
    }
}

