/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import java.util.List;
import javax.sql.DataSource;

public class DefaultDataSourceCreator {
    private List<DataSourceCreator> creators;

    public List<DataSourceCreator> getCreators() {
        return this.creators;
    }

    public void setCreators(List<DataSourceCreator> creators) {
        this.creators = creators;
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        DataSourceCreator dataSourceCreator = null;
        for (DataSourceCreator creator : this.creators) {
            if (!creator.support(dataSourceProperty)) continue;
            dataSourceCreator = creator;
            break;
        }
        if (dataSourceCreator == null) {
            throw new IllegalStateException("creator must not be null,please check the DataSourceCreator");
        }
        return dataSourceCreator.createDataSource(dataSourceProperty);
    }
}

