/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.provider;

import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.toolkit.CryptoUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractJdbcDataSourceProvider
extends AbstractDataSourceProvider
implements DynamicDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcDataSourceProvider.class);
    private final String driverClassName;
    private String url;
    private String username;
    private String password;
    private String publicKey;
    private static final Pattern ENC_PATTERN = Pattern.compile("^ENC\\((.*)\\)$");

    public AbstractJdbcDataSourceProvider(String url, String username, String password) {
        this(null, url, username, password);
    }

    public AbstractJdbcDataSourceProvider(String driverClassName, String url, String username, String password) {
        this(driverClassName, url, username, password, null);
    }

    public AbstractJdbcDataSourceProvider(String driverClassName, String url, String username, String password, String publicKey) {
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.publicKey = publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DataSource> loadDataSources() {
        block7: {
            Map<String, DataSource> map;
            Connection conn = null;
            Statement stmt = null;
            try {
                if (!StringUtils.isEmpty((Object)this.driverClassName)) {
                    Class.forName(this.driverClassName);
                    log.info("\u6210\u529f\u52a0\u8f7d\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f");
                }
                if (HussarUtils.isNotEmpty((Object)this.publicKey)) {
                    this.url = this.decrypt(this.publicKey, this.url);
                    this.password = this.decrypt(this.publicKey, this.password);
                    this.username = this.decrypt(this.publicKey, this.username);
                }
                conn = DriverManager.getConnection(this.url, this.username, this.password);
                log.info("\u6210\u529f\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
                stmt = conn.createStatement();
                Map<String, DataSourceProperty> dataSourcePropertiesMap = this.executeStmt(stmt);
                map = this.createDataSourceMap(dataSourcePropertiesMap);
                JdbcUtils.closeConnection((Connection)conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                JdbcUtils.closeConnection(conn);
                JdbcUtils.closeStatement(stmt);
            }
            JdbcUtils.closeStatement((Statement)stmt);
            return map;
        }
        return null;
    }

    protected abstract Map<String, DataSourceProperty> executeStmt(Statement var1) throws SQLException;

    private String decrypt(String publicKey, String cipherText) {
        Matcher matcher;
        if (StringUtils.hasText((String)cipherText) && (matcher = ENC_PATTERN.matcher(cipherText)).find()) {
            try {
                return CryptoUtils.decrypt(publicKey, matcher.group(1));
            }
            catch (Exception e) {
                log.error("master dataSource decrypt error ", (Throwable)e);
            }
        }
        return cipherText;
    }
}

