/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.ds;

import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class GroupDataSource {
    private String groupName;
    private DynamicDataSourceStrategy dynamicDataSourceStrategy;
    private Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();

    public GroupDataSource(String groupName, DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        this.setGroupName(groupName);
        this.dynamicDataSourceStrategy = dynamicDataSourceStrategy;
    }

    public DataSource addDatasource(String ds, DataSource dataSource) {
        return this.dataSourceMap.put(ds, dataSource);
    }

    public DataSource removeDatasource(String ds) {
        return this.dataSourceMap.remove(ds);
    }

    public String determineDsKey() {
        return this.dynamicDataSourceStrategy.determineKey(new ArrayList<String>(this.dataSourceMap.keySet()));
    }

    public DataSource determineDataSource() {
        return this.dataSourceMap.get(this.determineDsKey());
    }

    public int size() {
        return this.dataSourceMap.size();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

